/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.source;

import bdv.tools.transformation.TransformedSource;
import bdv.viewer.SourceAndConverter;
import ij.IJ;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterAndTimeRange;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceTransformHelper;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Transform>Sources Affine Transformation", description="Applies an affine transformation on several sources.")
public class SourceTransformerCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Select source(s)")
    SourceAndConverter<?>[] sacs;
    @Parameter(label="Matrix as comma separated numbers", required=false, callback="parseInput")
    String matrixCsv;
    @Parameter(style="format:0.#####E0")
    double m00 = 1.0;
    @Parameter(style="format:0.#####E0")
    double m01 = 0.0;
    @Parameter(style="format:0.#####E0")
    double m02 = 0.0;
    @Parameter(style="format:0.#####E0")
    double tx = 0.0;
    @Parameter(style="format:0.#####E0")
    double m10 = 0.0;
    @Parameter(style="format:0.#####E0")
    double m11 = 1.0;
    @Parameter(style="format:0.#####E0")
    double m12 = 0.0;
    @Parameter(style="format:0.#####E0")
    double ty = 0.0;
    @Parameter(style="format:0.#####E0")
    double m20 = 0.0;
    @Parameter(style="format:0.#####E0")
    double m21 = 0.0;
    @Parameter(style="format:0.#####E0")
    double m22 = 1.0;
    @Parameter(style="format:0.#####E0")
    double tz = 0.0;
    @Parameter(label="Initial timepoint (0 based)")
    int initimepoint;
    @Parameter(label="Number of timepoints (min 1)", min="1")
    int ntimepoints;

    public void run() {
        for (SourceAndConverter<?> sac : this.sacs) {
            AffineTransform3D at3D_global = new AffineTransform3D();
            at3D_global.set(this.m00, this.m01, this.m02, this.tx, this.m10, this.m11, this.m12, this.ty, this.m20, this.m21, this.m22, this.tz);
            if (sac.getSpimSource() instanceof TransformedSource) {
                SourceTransformHelper.mutate(at3D_global, new SourceAndConverterAndTimeRange(sac, this.initimepoint));
                continue;
            }
            SourceTransformHelper.append(at3D_global, new SourceAndConverterAndTimeRange(sac, this.initimepoint, this.initimepoint + this.ntimepoints));
        }
        SourceAndConverterServices.getBdvDisplayService().updateDisplays(this.sacs);
    }

    public void parseInput() {
        if (this.matrixCsv != null) {
            String[] inputs = this.matrixCsv.split(",");
            if (inputs.length == 12) {
                try {
                    this.m00 = Double.parseDouble(inputs[0]);
                    this.m01 = Double.parseDouble(inputs[1]);
                    this.m02 = Double.parseDouble(inputs[2]);
                    this.tx = Double.parseDouble(inputs[3]);
                    this.m10 = Double.parseDouble(inputs[4]);
                    this.m11 = Double.parseDouble(inputs[5]);
                    this.m12 = Double.parseDouble(inputs[6]);
                    this.ty = Double.parseDouble(inputs[7]);
                    this.m20 = Double.parseDouble(inputs[8]);
                    this.m21 = Double.parseDouble(inputs[9]);
                    this.m22 = Double.parseDouble(inputs[10]);
                    this.tz = Double.parseDouble(inputs[11]);
                }
                catch (Exception e) {
                    IJ.log((String)("Number parsing exception: " + e.getMessage()));
                }
            } else {
                IJ.log((String)"A matrix should have 12 elements");
            }
        }
    }
}

