/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.source;

import bdv.viewer.SourceAndConverter;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.log.SystemLogger;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.sourceandconverter.importer.MandelbrotSourceGetter;
import sc.fiji.bdvpg.sourceandconverter.importer.VoronoiSourceGetter;
import sc.fiji.bdvpg.sourceandconverter.importer.Wave3DSourceGetter;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Create Sample Source")
public class SampleSourceCreatorCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Sample name", choices={"Mandelbrot", "Wave3D", "Voronoi", "Big Voronoi"})
    String samplename;
    @Parameter(type=ItemIO.OUTPUT)
    SourceAndConverter<?> sac;

    public void run() {
        switch (this.samplename) {
            case "Mandelbrot": {
                this.sac = new MandelbrotSourceGetter().get();
                break;
            }
            case "Wave3D": {
                this.sac = new Wave3DSourceGetter().get();
                break;
            }
            case "Voronoi": {
                this.sac = new VoronoiSourceGetter(new long[]{512L, 512L, 1L}, 256, true).get();
                break;
            }
            case "Big Voronoi": {
                this.sac = new VoronoiSourceGetter(new long[]{2048L, 2048L, 2048L}, 65536, false).get();
                break;
            }
            default: {
                new SystemLogger().err("Invalid sample name");
            }
        }
    }
}

