/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.source;

import bdv.viewer.SourceAndConverter;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.sourceandconverter.importer.EmptySourceAndConverterCreator;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>New Source Based on Model Source", description="Defines an empty source which occupied the same volume as a model source but with a potentially different voxel size. Works with a single timepoint.")
public class NewSourceCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Model Source", description="Defines the portion of space covered by the new source")
    SourceAndConverter<?> model;
    @Parameter(label="Source name")
    String name;
    @Parameter(type=ItemIO.OUTPUT)
    SourceAndConverter<?> sac;
    @Parameter(label="Voxel Size X")
    double voxsizex;
    @Parameter(label="Voxel Size Y")
    double voxsizey;
    @Parameter(label="Voxel Size Z")
    double voxsizez;
    @Parameter(label="Timepoint (0 based index)")
    int timepoint;

    public void run() {
        this.sac = new EmptySourceAndConverterCreator(this.name, this.model, this.timepoint, this.voxsizex, this.voxsizey, this.voxsizez).get();
    }
}

