/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.source;

import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import ij.IJ;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.bdv.ManualRegistrationStarter;
import sc.fiji.bdvpg.bdv.ManualRegistrationStopper;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceTransformHelper;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Transform>Manual Sources Transformation", description="Manual transformation of selected sources. Works only with a single bdv window (the active one).The sources that are not displayed but selected are transformed. During the registration, the user isplaced in the reference of the moving sources. That's why they are not moving during the registration.")
public class ManualTransformCommand
implements BdvPlaygroundActionCommand {
    @Parameter(choices={"Mutate", "Append", "Append (all timepoints)", "Append (timepoints before)", "Append (timepoints after)", "Wrap", "Log"})
    String mode = "Mutate";
    @Parameter(label="Select Source(s)")
    SourceAndConverter<?>[] sacs;
    @Parameter
    BdvHandle bdvh;

    public void run() {
        ManualRegistrationStopper manualRegistrationStopper;
        ManualRegistrationStarter manualRegistrationStarter = new ManualRegistrationStarter(this.bdvh, this.sacs);
        switch (this.mode) {
            case "Mutate": {
                manualRegistrationStopper = new ManualRegistrationStopper(manualRegistrationStarter, SourceTransformHelper::mutate);
                break;
            }
            case "Append": {
                manualRegistrationStopper = new ManualRegistrationStopper(manualRegistrationStarter, SourceTransformHelper::append);
                break;
            }
            case "Append (all timepoints)": {
                manualRegistrationStopper = new ManualRegistrationStopper(manualRegistrationStarter, SourceTransformHelper::append);
                manualRegistrationStopper.setTimeRange(0, SourceAndConverterHelper.getMaxTimepoint(this.sacs));
                break;
            }
            case "Append (timepoints before)": {
                manualRegistrationStopper = new ManualRegistrationStopper(manualRegistrationStarter, SourceTransformHelper::append);
                manualRegistrationStopper.setTimeRange(0, this.bdvh.getViewerPanel().state().getCurrentTimepoint() + 1);
                break;
            }
            case "Append (timepoints after)": {
                manualRegistrationStopper = new ManualRegistrationStopper(manualRegistrationStarter, SourceTransformHelper::append);
                manualRegistrationStopper.setTimeRange(this.bdvh.getViewerPanel().state().getCurrentTimepoint(), SourceAndConverterHelper.getMaxTimepoint(this.sacs));
                break;
            }
            case "Log": {
                manualRegistrationStopper = new ManualRegistrationStopper(manualRegistrationStarter, (transform, source) -> SourceTransformHelper.log(transform, source, IJ::log));
                break;
            }
            default: {
                manualRegistrationStopper = new ManualRegistrationStopper(manualRegistrationStarter, SourceTransformHelper::createNewTransformedSourceAndConverter);
            }
        }
        manualRegistrationStarter.run();
        JFrame frameStopManualTransformation = new JFrame();
        JPanel pane = new JPanel();
        JButton buttonApply = new JButton("Apply And Finish");
        buttonApply.addActionListener(e -> {
            manualRegistrationStopper.run();
            frameStopManualTransformation.dispatchEvent(new WindowEvent(frameStopManualTransformation, 201));
        });
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.addActionListener(e -> {
            new ManualRegistrationStopper(manualRegistrationStarter, SourceTransformHelper::cancel).run();
            frameStopManualTransformation.dispatchEvent(new WindowEvent(frameStopManualTransformation, 201));
            frameStopManualTransformation.dispose();
        });
        pane.add(buttonApply);
        pane.add(buttonCancel);
        frameStopManualTransformation.add(pane);
        frameStopManualTransformation.setTitle("Registration");
        frameStopManualTransformation.pack();
        frameStopManualTransformation.setVisible(true);
    }
}

