/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.source;

import bdv.viewer.SourceAndConverter;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.scijava.services.ui.SourceFilterNode;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Make Metadata Filter Node", description="Adds a node in the tree view which selects the sources which contain a certain key metadata and which matches a certain regular expression")
public class MakeMetadataFilterNodeCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Name of the node")
    String groupname;
    @Parameter(label="Select Metadata Key")
    String key;
    @Parameter(label="Regular expression for Metadata Value (\".*\" matches everything)")
    String valueregex = ".*";
    @Parameter
    SourceAndConverterService sac_service;

    public void run() {
        SourceFilterNode sfn = new SourceFilterNode(this.sac_service.getUI().getTreeModel(), this.groupname, sac -> {
            if (this.sac_service.containsMetadata((SourceAndConverter<?>)sac, this.key)) {
                Object o = this.sac_service.getMetadata((SourceAndConverter<?>)sac, this.key);
                if (o instanceof String) {
                    String str = (String)o;
                    return str.matches(this.valueregex);
                }
                return false;
            }
            return false;
        }, false);
        this.sac_service.getUI().addNode(sfn);
    }
}

