/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.source;

import bdv.viewer.SourceAndConverter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.imagej.display.ColorTables;
import net.imagej.lut.LUTService;
import net.imglib2.converter.Converter;
import net.imglib2.display.ColorTable;
import org.scijava.ItemIO;
import org.scijava.command.DynamicCommand;
import org.scijava.convert.ConvertService;
import org.scijava.module.Module;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.sourceandconverter.display.ConverterChanger;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Display>Create New Source (Set LUT)", initializer="init", description="Duplicate one or several sources and sets an (identical) Look Up Table for these duplicated sources")
public class LUTSourceCreatorCommand
extends DynamicCommand
implements BdvPlaygroundActionCommand {
    @Parameter
    LUTService lutservice;
    @Parameter(label="LUT name", persist=false, callback="nameChanged")
    String choice = "Gray";
    @Parameter(required=false, label="LUT", persist=false)
    ColorTable table = ColorTables.GRAYS;
    @Parameter
    ConvertService cs;
    private Map<String, URL> luts = null;
    @Parameter(label="Select Source(s)")
    SourceAndConverter<?>[] sacs;
    @Parameter(type=ItemIO.OUTPUT)
    SourceAndConverter<?>[] sacs_out;

    public void run() {
        this.sacs_out = new SourceAndConverter[this.sacs.length];
        for (int i = 0; i < this.sacs.length; ++i) {
            this.sacs_out[i] = this.convert(this.sacs[i]);
        }
    }

    private <T> SourceAndConverter<T> convert(SourceAndConverter<T> sac) {
        Converter bdvLut = (Converter)this.cs.convert((Object)this.table, Converter.class);
        ConverterChanger<T> cc = new ConverterChanger<T>(sac, bdvLut);
        cc.run();
        return cc.get();
    }

    protected void init() {
        this.luts = this.lutservice.findLUTs();
        ArrayList<String> choices = new ArrayList<String>();
        for (Map.Entry<String, URL> entry : this.luts.entrySet()) {
            choices.add(entry.getKey());
        }
        Collections.sort(choices);
        MutableModuleItem input = this.getInfo().getMutableInput("choice", String.class);
        input.setChoices(choices);
        input.setValue((Module)this, choices.get(0));
        this.nameChanged();
    }

    protected void nameChanged() {
        try {
            this.table = this.lutservice.loadLUT(this.luts.get(this.choice));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

