/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.source;

import bdv.viewer.SourceAndConverter;
import java.text.DecimalFormat;
import org.scijava.ItemVisibility;
import org.scijava.command.InteractiveCommand;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.display.BrightnessAdjuster;

@Plugin(type=BdvPlaygroundActionCommand.class, initializer="init", menuPath="Plugins>BigDataViewer-Playground>Sources>Display>Set Sources Brightness (Interactive)")
public class InteractiveBrightnessAdjusterCommand
extends InteractiveCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Sources :", required=false, description="Label the sources controlled by this window", persist=false)
    String customsourcelabel = "Label your sources here";
    @Parameter(label="Select Source(s)")
    SourceAndConverter<?>[] sacs;
    @Parameter(visibility=ItemVisibility.MESSAGE, required=false, style="text field")
    String message = "Display Range [ NaN - NaN ]";
    @Parameter(callback="updateMessage")
    double min;
    @Parameter(callback="updateMessage")
    double max;
    @Parameter(label="relative Minimum", style="slider", min="0", max="1000", callback="updateMessage")
    double minslider;
    @Parameter(label="relative Maximum", style="slider", min="0", max="1000", callback="updateMessage")
    double maxslider;
    boolean firstTimeCalled = true;
    boolean secondTimeCalled = true;
    final DecimalFormat formatter = new DecimalFormat("#.###");

    public InteractiveBrightnessAdjusterCommand() {
        super(new String[0]);
    }

    public void run() {
        if (!this.firstTimeCalled && !this.secondTimeCalled) {
            double minValue = this.min + this.minslider / 1000.0 * (this.max - this.min);
            double maxValue = this.min + this.maxslider / 1000.0 * (this.max - this.min);
            for (SourceAndConverter<?> source : this.sacs) {
                new BrightnessAdjuster(source, minValue, maxValue).run();
            }
        } else {
            this.init();
            if (this.firstTimeCalled) {
                this.firstTimeCalled = false;
            } else if (this.secondTimeCalled) {
                this.secondTimeCalled = false;
            }
        }
    }

    public void updateMessage() {
        this.formatter.setMinimumFractionDigits(3);
        double minValue = this.min + this.minslider / 1000.0 * (this.max - this.min);
        double maxValue = this.min + this.maxslider / 1000.0 * (this.max - this.min);
        this.message = "Display Range [" + this.formatter.format(minValue) + " - " + this.formatter.format(maxValue) + "]";
    }

    public void init() {
        if (this.sacs != null && this.sacs.length > 0) {
            double minSource = SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(this.sacs[0]).getDisplayRangeMin();
            double maxSource = SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(this.sacs[0]).getDisplayRangeMax();
            this.min = minSource >= 0.0 ? 0.0 : minSource;
            this.max = maxSource > 65535.0 ? maxSource : (maxSource > 255.0 ? 65535.0 : (maxSource > 1.0 ? 255.0 : 1.0));
            this.minslider = (minSource - this.min) / (this.max - this.min) * 1000.0;
            this.maxslider = (maxSource - this.min) / (this.max - this.min) * 1000.0;
            this.message = "Display Range [ NaN - NaN ]";
        }
    }
}

