/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.source;

import bdv.viewer.SourceAndConverter;
import net.imglib2.Volatile;
import net.imglib2.converter.Converter;
import net.imglib2.display.ColorConverter;
import net.imglib2.type.numeric.ARGBType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.ColorRGB;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.sourceandconverter.display.ConverterChanger;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Display>Create New Source (Set Color)", description="Duplicate one or several sources and sets a new color for these sources")
public class ColorSourceCreatorCommand
implements BdvPlaygroundActionCommand {
    @Parameter
    ColorRGB color = new ColorRGB(255, 255, 255);
    @Parameter(label="Select Source(s)")
    SourceAndConverter<?>[] sacs;

    public void run() {
        for (SourceAndConverter<?> source : this.sacs) {
            this.createAndChangeConverter(source);
        }
    }

    private <T> void createAndChangeConverter(SourceAndConverter<T> source) {
        ARGBType imglib2color = new ARGBType(ARGBType.rgba((int)this.color.getRed(), (int)this.color.getGreen(), (int)this.color.getBlue(), (int)this.color.getAlpha()));
        Converter<T, ARGBType> c = SourceAndConverterHelper.createConverter(source.getSpimSource());
        assert (c instanceof ColorConverter);
        ((ColorConverter)c).setColor(imglib2color);
        Converter<Volatile<T>, ARGBType> vc = null;
        if (source.asVolatile() != null) {
            vc = SourceAndConverterHelper.createConverter(source.asVolatile().getSpimSource());
            assert (vc != null);
            ((ColorConverter)vc).setColor(imglib2color);
        }
        ConverterChanger<T> cc = new ConverterChanger<T>(source, c, vc);
        cc.run();
        cc.get();
    }
}

