/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.source;

import bdv.tools.brightness.ConverterSetup;
import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterBdvDisplayService;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.sourceandconverter.register.BigWarpLauncher;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Register>Launch BigWarp", description="Starts BigWarp from existing sources")
public class BigWarpLauncherCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Window title for BigWarp")
    String bigwarpname;
    @Parameter(label="Moving Source(s)")
    SourceAndConverter<?>[] movingsources;
    @Parameter(label="Fixed Source(s)")
    SourceAndConverter<?>[] fixedsources;
    @Parameter(type=ItemIO.OUTPUT)
    BdvHandle bdvhq;
    @Parameter(type=ItemIO.OUTPUT)
    BdvHandle bdvhp;
    @Parameter(type=ItemIO.OUTPUT)
    SourceAndConverter<?>[] warpedsources;
    @Parameter(type=ItemIO.OUTPUT)
    SourceAndConverter<?> gridsource;
    @Parameter(type=ItemIO.OUTPUT)
    SourceAndConverter<?> warpmagnitudesource;
    @Parameter
    SourceAndConverterBdvDisplayService bsds;
    @Parameter
    SourceAndConverterService sac_service;

    public void run() {
        List<SourceAndConverter<?>> movingSacs = Arrays.stream(this.movingsources).collect(Collectors.toList());
        List<SourceAndConverter<?>> fixedSacs = Arrays.stream(this.fixedsources).collect(Collectors.toList());
        List<ConverterSetup> converterSetups = Arrays.stream(this.movingsources).map(src -> this.sac_service.getConverterSetup((SourceAndConverter<?>)src)).collect(Collectors.toList());
        converterSetups.addAll(Arrays.stream(this.fixedsources).map(src -> this.sac_service.getConverterSetup((SourceAndConverter<?>)src)).collect(Collectors.toList()));
        BigWarpLauncher bwl = new BigWarpLauncher(movingSacs, fixedSacs, this.bigwarpname, converterSetups);
        bwl.run();
        this.bdvhq = bwl.getBdvHandleQ();
        this.bdvhp = bwl.getBdvHandleP();
        this.bsds.pairClosing(this.bdvhq, this.bdvhp);
        this.gridsource = bwl.getGridSource();
        this.warpmagnitudesource = bwl.getWarpMagnitudeSource();
        this.warpedsources = bwl.getWarpedSources();
    }
}

