/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.source;

import bdv.tools.transformation.TransformedSource;
import bdv.viewer.SourceAndConverter;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterBdvDisplayService;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterAndTimeRange;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceTransformHelper;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Transform>Basic Transformation", description="Performs basic transformation (rotate / flip) along X Y Z axis for several sources. If global is selected, the transformation is performed relative to the global origin (0,0,0). If global is not selected, the center of each source is unchanged.")
public class BasicTransformerCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Select source(s)")
    SourceAndConverter<?>[] sacs;
    @Parameter(choices={"Flip", "Rot90", "Rot180", "Rot270"})
    String type;
    @Parameter(choices={"X", "Y", "Z"})
    String axis;
    @Parameter(label="Initial timepoint (0 based)")
    int initimepoint;
    @Parameter(label="Number of timepoints (min 1)", min="1")
    int ntimepoints;
    @Parameter(label="Global transform (relative to the origin of the world)")
    boolean globalchange;
    @Parameter
    SourceAndConverterBdvDisplayService bdvDisplayService;

    public void run() {
        for (SourceAndConverter<?> sac : this.sacs) {
            AffineTransform3D at3D_global = new AffineTransform3D();
            at3D_global.identity();
            switch (this.type) {
                case "Flip": {
                    this.flip(at3D_global);
                    break;
                }
                case "Rot90": {
                    this.rot(1, at3D_global);
                    break;
                }
                case "Rot180": {
                    this.rot(2, at3D_global);
                    break;
                }
                case "Rot270": {
                    this.rot(3, at3D_global);
                }
            }
            if (this.globalchange) {
                if (sac.getSpimSource() instanceof TransformedSource) {
                    SourceTransformHelper.mutate(at3D_global, new SourceAndConverterAndTimeRange(sac, this.initimepoint, this.initimepoint + this.ntimepoints));
                    continue;
                }
                SourceTransformHelper.append(at3D_global, new SourceAndConverterAndTimeRange(sac, this.initimepoint, this.initimepoint + this.ntimepoints));
                continue;
            }
            for (int timepoint = this.initimepoint; timepoint < this.initimepoint + this.ntimepoints; ++timepoint) {
                AffineTransform3D at3D = new AffineTransform3D();
                at3D.identity();
                sac.getSpimSource().getSourceTransform(timepoint, 0, at3D);
                long[] dims = new long[3];
                sac.getSpimSource().getSource(timepoint, 0).dimensions(dims);
                RealPoint ptCenterGlobalBefore = new RealPoint(3);
                RealPoint ptCenterPixel = new RealPoint(new double[]{((double)dims[0] - 1.0) / 2.0, ((double)dims[1] - 1.0) / 2.0, ((double)dims[2] - 1.0) / 2.0});
                at3D.apply((RealLocalizable)ptCenterPixel, (RealPositionable)ptCenterGlobalBefore);
                RealPoint ptCenterGlobalAfter = new RealPoint(3);
                at3D_global.apply((RealLocalizable)ptCenterGlobalBefore, (RealPositionable)ptCenterGlobalAfter);
                double[] m = at3D_global.getRowPackedCopy();
                m[3] = m[3] - (ptCenterGlobalAfter.getDoublePosition(0) - ptCenterGlobalBefore.getDoublePosition(0));
                m[7] = m[7] - (ptCenterGlobalAfter.getDoublePosition(1) - ptCenterGlobalBefore.getDoublePosition(1));
                m[11] = m[11] - (ptCenterGlobalAfter.getDoublePosition(2) - ptCenterGlobalBefore.getDoublePosition(2));
                at3D_global.set(m);
                if (sac.getSpimSource() instanceof TransformedSource) {
                    SourceTransformHelper.mutate(at3D_global, new SourceAndConverterAndTimeRange(sac, timepoint));
                    continue;
                }
                SourceTransformHelper.append(at3D_global, new SourceAndConverterAndTimeRange(sac, timepoint));
            }
        }
        this.bdvDisplayService.updateDisplays(this.sacs);
    }

    private void flip(AffineTransform3D at3D) {
        switch (this.axis) {
            case "X": {
                at3D.set(-1.0, 0, 0);
                break;
            }
            case "Y": {
                at3D.set(-1.0, 1, 1);
                break;
            }
            case "Z": {
                at3D.set(-1.0, 2, 2);
            }
        }
    }

    private void rot(int quarterTurn, AffineTransform3D at3D) {
        switch (this.axis) {
            case "X": {
                at3D.rotate(0, (double)quarterTurn * Math.PI / 2.0);
                break;
            }
            case "Y": {
                at3D.rotate(1, (double)quarterTurn * Math.PI / 2.0);
                break;
            }
            case "Z": {
                at3D.rotate(2, (double)quarterTurn * Math.PI / 2.0);
            }
        }
    }
}

