/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.bvv;

import bdv.viewer.SourceAndConverter;
import bvv.vistools.BvvHandle;
import ij.IJ;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.bdv.navigate.ViewerTransformAdjuster;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.viewers.ViewerAdapter;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>BVV>BVV - Show Sources", description="Show sources in a BigVolumeViewer window - limited to 16 bit images")
public class BvvSourcesAdderCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Select BVV Window(s)")
    BvvHandle bvvh;
    @Parameter(label="Adjust View on Source")
    boolean adjustviewonsource;
    @Parameter(label="Select source(s)")
    SourceAndConverter<?>[] sacs;

    public void run() {
        for (SourceAndConverter<?> sac : this.sacs) {
            if (sac.getSpimSource().getType() instanceof UnsignedShortType) {
                this.bvvh.getConverterSetups().put(sac, SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(sac));
                this.bvvh.getViewerPanel().state().addSource(sac);
                this.bvvh.getViewerPanel().state().setSourceActive(sac, true);
                continue;
            }
            IJ.log((String)("Source " + sac.getSpimSource().getName() + " is not an unsigned 16 bit image. Bvv does not support this kind of images (yet)."));
        }
        if (this.adjustviewonsource && this.sacs.length > 0) {
            new ViewerTransformAdjuster(new ViewerAdapter(this.bvvh), this.sacs).run();
        }
    }
}

