/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.bvv;

import bvv.vistools.BvvHandle;
import bvv.vistools.BvvOptions;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import javax.swing.JFrame;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.bvv.BvvCreator;
import sc.fiji.bdvpg.bvv.BvvHandleHelper;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.viewers.ViewerAdapter;
import sc.fiji.bdvpg.viewers.ViewerOrthoSyncStarter;
import sc.fiji.bdvpg.viewers.ViewerStateSyncStarter;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>BVV>BVV - Create Orthogonal Views", description="Creates 3 BVV windows with synchronized orthogonal views")
public class BvvOrthoWindowCreatorCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Interpolate")
    public boolean interpolate = false;
    @Parameter(label="Number of timepoints (1 for a single timepoint)")
    public int ntimepoints = 1;
    @Parameter(label="Display (0 if you have one screen)")
    int screen = 0;
    @Parameter(label="X Front Window location")
    int locationx = 150;
    @Parameter(label="Y Front Window location")
    int locationy = 150;
    @Parameter(label="Window Width")
    int sizex = 500;
    @Parameter(label="Window Height")
    int sizey = 500;
    public boolean synctime = true;
    @Parameter
    boolean synchronize_sources = true;
    @Parameter(type=ItemIO.OUTPUT)
    public BvvHandle bvvhx;
    @Parameter(type=ItemIO.OUTPUT)
    public BvvHandle bvvhy;
    @Parameter(type=ItemIO.OUTPUT)
    public BvvHandle bvvhz;

    public void run() {
        this.bvvhx = this.createBvv("-Front", this.locationx, this.locationy);
        this.bvvhx.getViewerPanel().state().setNumTimepoints(this.ntimepoints);
        this.bvvhy = this.createBvv("-Right", this.locationx + this.sizex + 10, this.locationy);
        this.bvvhy.getViewerPanel().state().setNumTimepoints(this.ntimepoints);
        this.bvvhz = this.createBvv("-Bottom", this.locationx, this.locationy + this.sizey + 40);
        this.bvvhz.getViewerPanel().state().setNumTimepoints(this.ntimepoints);
        new ViewerOrthoSyncStarter(new ViewerAdapter(this.bvvhx), new ViewerAdapter(this.bvvhz), new ViewerAdapter(this.bvvhy), this.synctime).run();
        if (this.synchronize_sources) {
            new ViewerStateSyncStarter(new ViewerAdapter(this.bvvhx), new ViewerAdapter(this.bvvhy), new ViewerAdapter(this.bvvhz)).run();
        }
    }

    BvvHandle createBvv(String suffix, double locX, double locY) {
        BvvOptions opts = BvvOptions.options();
        BvvHandle bvvh = new BvvCreator(opts, this.ntimepoints).get();
        BvvHandleHelper.setWindowTitle(bvvh, BvvHandleHelper.getWindowTitle(bvvh) + suffix);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        JFrame frame = BvvHandleHelper.getJFrame(bvvh);
        if (this.screen > -1 && this.screen < gd.length) {
            frame.setLocation(gd[this.screen].getDefaultConfiguration().getBounds().x + (int)locX, (int)locY);
        } else if (gd.length > 0) {
            frame.setLocation(gd[0].getDefaultConfiguration().getBounds().x + (int)locX, (int)locY);
        } else {
            throw new RuntimeException("No Screens Found");
        }
        return bvvh;
    }
}

