/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.bdv;

import bdv.util.BdvHandle;
import ij.IJ;
import java.awt.Font;
import javax.swing.SwingUtilities;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.bdv.overlay.SourceNameOverlayAdder;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>BDV>BDV - Add Sources Name Overlay", description="Adds a source name overlay onto BDV windows")
public class MultiBdvSourceNameOverlayAdderCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Select BDV Windows", persist=false)
    BdvHandle[] bdvhs;
    @Parameter(label="Font Size")
    int fontSize = 18;
    @Parameter(choices={"Courier", "TimesRoman"})
    String fontString;

    public void run() {
        if (this.bdvhs.length == 0) {
            IJ.log((String)"Please make sure to select a Bdv window.");
        }
        Font font = new Font(this.fontString, 0, this.fontSize);
        for (BdvHandle bdvh : this.bdvhs) {
            SwingUtilities.invokeLater(() -> new SourceNameOverlayAdder(bdvh, font).run());
        }
    }
}

