/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.bdv;

import bdv.util.BdvHandle;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.bdv.navigate.ViewerTransformChanger;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>BDV>BDV - Change view transform", description="Applies a simple view transform (translation / rotation) to a BDV window")
public class BdvViewTransformatorCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Select BDV Windows")
    BdvHandle bdvh;
    @Parameter(label="Translate in X")
    public Double translatex = 0.0;
    @Parameter(label="Translate in Y")
    public Double translatey = 0.0;
    @Parameter(label="Translate in Z")
    public Double translatez = 0.0;
    @Parameter(label="Rotate around X")
    public Double rotatearoundx = 0.0;
    @Parameter(label="Rotate around Y")
    public Double rotatearoundy = 0.0;
    @Parameter(label="Rotate around Z")
    public Double rotatearoundz = 0.0;

    public void run() {
        AffineTransform3D affineTransform3D = new AffineTransform3D();
        affineTransform3D.translate(new double[]{this.translatex, this.translatey, this.translatez});
        affineTransform3D.rotate(0, this.rotatearoundx.doubleValue());
        affineTransform3D.rotate(1, this.rotatearoundy.doubleValue());
        affineTransform3D.rotate(2, this.rotatearoundz.doubleValue());
        new ViewerTransformChanger(this.bdvh, affineTransform3D, true, 0).run();
    }
}

