/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.bdv;

import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.bdv.navigate.ViewerTransformAdjuster;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterBdvDisplayService;
import sc.fiji.bdvpg.sourceandconverter.display.BrightnessAutoAdjuster;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>BDV>BDV - Show Sources (new Bdv window)", description="Displays one or several sources into a new BDV window")
public class BdvSourcesShowCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Select Source(s)")
    SourceAndConverter<?>[] sacs;
    @Parameter(label="Auto Contrast")
    boolean autocontrast;
    @Parameter(label="Adjust View on Source")
    boolean adjustviewonsource;
    @Parameter(label="Interpolate")
    public boolean interpolate = false;
    @Parameter(type=ItemIO.OUTPUT)
    public BdvHandle bdvh;
    @Parameter
    SourceAndConverterBdvDisplayService bdvDisplayService;

    public void run() {
        this.bdvh = this.bdvDisplayService.getNewBdv();
        this.bdvDisplayService.show(this.bdvh, this.sacs);
        if (this.autocontrast) {
            for (SourceAndConverter<?> sac : this.sacs) {
                int timepoint = this.bdvh.getViewerPanel().state().getCurrentTimepoint();
                new BrightnessAutoAdjuster(sac, timepoint).run();
            }
        }
        if (this.adjustviewonsource && this.sacs.length > 0) {
            new ViewerTransformAdjuster(this.bdvh, this.sacs).run();
        }
    }
}

