/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.bdv;

import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.bdv.navigate.ViewerTransformAdjuster;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterBdvDisplayService;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.sourceandconverter.display.BrightnessAutoAdjuster;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>BDV>BDV - Show Sources", description="Adds one or several sources to an existing BDV window")
public class BdvSourcesAdderCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Select BDV Window")
    BdvHandle bdvh;
    @Parameter(label="Select Source(s)")
    SourceAndConverter<?>[] sacs;
    @Parameter(label="Auto Contrast")
    boolean autocontrast;
    @Parameter(label="Adjust View on Source")
    boolean adjustviewonsource;
    @Parameter
    SourceAndConverterBdvDisplayService bdvDisplayService;

    public void run() {
        this.bdvDisplayService.show(this.bdvh, SourceAndConverterHelper.sortDefault(this.sacs));
        if (this.autocontrast) {
            for (SourceAndConverter<?> sac : this.sacs) {
                int timepoint = this.bdvh.getViewerPanel().state().getCurrentTimepoint();
                new BrightnessAutoAdjuster(sac, timepoint).run();
            }
        }
        if (this.adjustviewonsource && this.sacs.length > 0) {
            new ViewerTransformAdjuster(this.bdvh, this.sacs).run();
        }
    }
}

