/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.bdv;

import bdv.util.BdvHandle;
import bdv.util.BdvHandleFrame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterBdvDisplayService;
import sc.fiji.bdvpg.viewers.ViewerAdapter;
import sc.fiji.bdvpg.viewers.ViewerOrthoSyncStarter;
import sc.fiji.bdvpg.viewers.ViewerStateSyncStarter;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>BDV>BDV - Create Orthogonal Views", description="Creates 3 BDV windows with synchronized orthogonal views")
public class BdvOrthoCreatorCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Interpolate")
    public boolean interpolate = false;
    @Parameter(label="Number of timepoints (1 for a single timepoint)")
    public int ntimepoints = 1;
    @Parameter(label="Add cross overlay to show view plane locations")
    public boolean drawcrosses = true;
    @Parameter(label="Display (0 if you have one screen)")
    int screen = 0;
    @Parameter(label="X Front Window location")
    int locationx = 150;
    @Parameter(label="Y Front Window location")
    int locationy = 150;
    @Parameter(label="Window Width")
    int sizex = 500;
    @Parameter(label="Window Height")
    int sizey = 500;
    public boolean synctime = true;
    @Parameter(type=ItemIO.OUTPUT)
    public BdvHandle bdvhx;
    @Parameter(type=ItemIO.OUTPUT)
    public BdvHandle bdvhy;
    @Parameter(type=ItemIO.OUTPUT)
    public BdvHandle bdvhz;
    @Parameter
    SourceAndConverterBdvDisplayService sacDisplayService;
    @Parameter
    boolean synchronize_sources = true;

    public void run() {
        this.bdvhx = this.createBdv("-Front", this.locationx, this.locationy);
        this.bdvhy = this.createBdv("-Right", this.locationx + this.sizex + 10, this.locationy);
        this.bdvhz = this.createBdv("-Bottom", this.locationx, this.locationy + this.sizey + 40);
        if (this.drawcrosses) {
            BdvHandleHelper.addCenterCross(this.bdvhx);
            BdvHandleHelper.addCenterCross(this.bdvhy);
            BdvHandleHelper.addCenterCross(this.bdvhz);
        }
        this.bdvhx.getViewerPanel().state().setNumTimepoints(this.ntimepoints);
        this.bdvhy.getViewerPanel().state().setNumTimepoints(this.ntimepoints);
        this.bdvhz.getViewerPanel().state().setNumTimepoints(this.ntimepoints);
        ViewerOrthoSyncStarter starter = new ViewerOrthoSyncStarter(new ViewerAdapter(this.bdvhx), new ViewerAdapter(this.bdvhz), new ViewerAdapter(this.bdvhy), this.synctime);
        starter.run();
        if (this.synchronize_sources) {
            new ViewerStateSyncStarter(new ViewerAdapter(this.bdvhx), new ViewerAdapter(this.bdvhy), new ViewerAdapter(this.bdvhz)).run();
        }
    }

    BdvHandle createBdv(String suffix, double locX, double locY) {
        BdvHandle bdvh = this.sacDisplayService.getNewBdv();
        BdvHandleHelper.setWindowTitle(bdvh, BdvHandleHelper.getWindowTitle(bdvh) + suffix);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        if (bdvh instanceof BdvHandleFrame) {
            JFrame frame = BdvHandleHelper.getJFrame(bdvh);
            SwingUtilities.invokeLater(() -> {
                if (this.screen > -1 && this.screen < gd.length) {
                    frame.setLocation(gd[this.screen].getDefaultConfiguration().getBounds().x + (int)locX, (int)locY);
                } else if (gd.length > 0) {
                    frame.setLocation(gd[0].getDefaultConfiguration().getBounds().x + (int)locX, (int)locY);
                } else {
                    throw new RuntimeException("No Screens Found");
                }
                frame.setSize(this.sizex, this.sizey);
            });
        }
        return bdvh;
    }
}

