/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.bdv;

import java.util.Arrays;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.bdv.supplier.DefaultBdvSupplier;
import sc.fiji.bdvpg.bdv.supplier.SerializableBdvOptions;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterBdvDisplayService;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>BDV>BDV - Set BDV window (default)", description="Set preferences of Bdv Window")
public class BdvDefaultViewerSetterCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Click this checkbox to ignore all parameters and reset the default viewer", persist=false)
    boolean resetToDefault = false;
    @Parameter
    int width = 640;
    @Parameter
    int height = 480;
    @Parameter
    String screenscales = "1, 0.75, 0.5, 0.25, 0.125";
    @Parameter
    long targetrenderms = 30L;
    @Parameter
    int numrenderingthreads = 3;
    @Parameter
    int numsourcegroups = 10;
    @Parameter
    String frametitle = "BigDataViewer";
    @Parameter
    boolean is2d = false;
    @Parameter
    boolean interpolate = false;
    @Parameter
    int numtimepoints = 1;
    @Parameter
    SourceAndConverterBdvDisplayService sacDisplayService;

    public void run() {
        if (this.resetToDefault) {
            DefaultBdvSupplier bdvSupplier = new DefaultBdvSupplier(new SerializableBdvOptions());
            this.sacDisplayService.setDefaultBdvSupplier(bdvSupplier);
        } else {
            SerializableBdvOptions options = new SerializableBdvOptions();
            options.frameTitle = this.frametitle;
            options.is2D = this.is2d;
            options.numRenderingThreads = this.numrenderingthreads;
            options.screenScales = Arrays.stream(this.screenscales.split(",")).mapToDouble(Double::parseDouble).toArray();
            options.height = this.height;
            options.width = this.width;
            options.numSourceGroups = this.numsourcegroups;
            options.numTimePoints = this.numtimepoints;
            options.interpolate = this.interpolate;
            DefaultBdvSupplier bdvSupplier = new DefaultBdvSupplier(options);
            this.sacDisplayService.setDefaultBdvSupplier(bdvSupplier);
        }
    }
}

