/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command;

import com.google.gson.Gson;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.prefs.PrefService;
import org.scijava.widget.Button;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.cache.GlobalCacheBuilder;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Set cache options", description="Sets Bdv Playground cache options (needs a restart)", initializer="initialize")
public class CacheOptionsCommand
implements BdvPlaygroundActionCommand {
    public static final Logger logger = LoggerFactory.getLogger(CacheOptionsCommand.class);
    @Parameter
    PrefService prefs;
    @Parameter(label="Cache type", choices={"Caffeine", "LinkedHashMap"}, persist=false)
    String cache_type;
    @Parameter(label="Log cache (ms between log), negative to avoid logging", persist=false)
    int log_ms;
    @Parameter(label="Rule: use a ratio of all memory available (%)", callback="useRatio", persist=false)
    int mem_ratio_pc;
    @Parameter(label="Rule: set a size for cache (Mb)", callback="useMbForCache", persist=false)
    int mem_for_cache_mb;
    @Parameter(label="Rule: set a size for the rest of the application (Mb)", callback="useMbForElse", persist=false)
    int mem_for_everything_else_mb;
    @Parameter(label="Reset to default", callback="reset")
    Button button;

    public void run() {
        GlobalCacheBuilder builder = GlobalCacheBuilder.builder();
        switch (this.cache_type) {
            case "Caffeine": {
                builder.caffeine();
                break;
            }
            case "LinkedHashMap": {
                builder.linkedHashMap();
            }
        }
        if (this.log_ms > 0) {
            builder.log(this.log_ms);
        }
        if (this.mem_for_cache_mb > 0) {
            builder.memoryForCache((long)this.mem_for_cache_mb * 1024L * 1024L);
        }
        if (this.mem_for_everything_else_mb > 0) {
            builder.memoryForEverythingElse((long)this.mem_for_everything_else_mb * 1024L * 1024L);
        }
        if (this.mem_ratio_pc > 0) {
            builder.memoryRatioForCache((double)this.mem_ratio_pc / 100.0);
        }
        String serializedCacheBuilder = new Gson().toJson((Object)builder, GlobalCacheBuilder.class);
        logger.info("Cache builder : " + serializedCacheBuilder);
        this.prefs.put(SourceAndConverterService.class, "cache.builder", serializedCacheBuilder);
    }

    void initialize() {
        Gson gson = new Gson();
        String defaultCacheBuilder = gson.toJson((Object)GlobalCacheBuilder.builder(), GlobalCacheBuilder.class);
        String cacheBuilderJson = this.prefs.get(SourceAndConverterService.class, "cache.builder", defaultCacheBuilder);
        try {
            GlobalCacheBuilder builder = (GlobalCacheBuilder)gson.fromJson(cacheBuilderJson, GlobalCacheBuilder.class);
            this.setParametersFromBuilder(builder);
        }
        catch (Exception e) {
            this.reset();
        }
    }

    void setParametersFromBuilder(GlobalCacheBuilder builder) {
        this.cache_type = builder.getCacheType();
        this.mem_ratio_pc = builder.getMemoryRatioForCache() > 0.0 ? (int)(builder.getMemoryRatioForCache() * 100.0) : -1;
        this.mem_for_cache_mb = builder.getMemoryInBytesForCache() > 0L ? (int)(builder.getMemoryInBytesForCache() / 0x100000L) : -1;
        this.mem_for_everything_else_mb = builder.getMemoryInBytesForEverythingElse() > 0L ? (int)(builder.getMemoryInBytesForEverythingElse() / 0x100000L) : -1;
        this.log_ms = builder.getLog() ? builder.getMsBetweenLog() : -1;
    }

    void reset() {
        this.setParametersFromBuilder(GlobalCacheBuilder.builder());
    }

    void useRatio() {
        this.mem_for_cache_mb = -1;
        this.mem_for_everything_else_mb = -1;
    }

    void useMbForCache() {
        this.mem_ratio_pc = -1;
        this.mem_for_everything_else_mb = -1;
    }

    void useMbForElse() {
        this.mem_ratio_pc = -1;
        this.mem_for_cache_mb = -1;
    }
}

