/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.adapter.source;

import bdv.tools.transformation.TransformedSource;
import bdv.viewer.SourceAndConverter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.adapter.source.ISourceAdapter;
import sc.fiji.bdvpg.services.SourceAndConverterAdapter;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceAffineTransformer;

@Plugin(type=ISourceAdapter.class)
public class TransformedSourceAdapter
implements ISourceAdapter<TransformedSource> {
    SourceAndConverterAdapter sacSerializer;

    @Override
    public void setSacSerializer(SourceAndConverterAdapter sacSerializer) {
        this.sacSerializer = sacSerializer;
    }

    @Override
    public Class<TransformedSource> getSourceClass() {
        return TransformedSource.class;
    }

    @Override
    public JsonElement serialize(SourceAndConverter sac, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject obj = new JsonObject();
        TransformedSource source = (TransformedSource)sac.getSpimSource();
        AffineTransform3D fixedTr = new AffineTransform3D();
        AffineTransform3D incrTr = new AffineTransform3D();
        source.getIncrementalTransform(incrTr);
        source.getFixedTransform(fixedTr);
        obj.add("affinetransform_fixed", jsonSerializationContext.serialize((Object)fixedTr, RealTransform.class));
        Integer idWrapped = this.sacSerializer.getSourceToId().get(source.getWrappedSource());
        if (idWrapped == null) {
            System.err.println(source.getName() + " can't be serialized : the wrapped source " + source.getWrappedSource().getName() + " couldn't be identified. ");
            return null;
        }
        obj.addProperty("wrapped_source_id", (Number)idWrapped);
        return obj;
    }

    @Override
    public SourceAndConverter deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        SourceAndConverter wrappedSac;
        JsonObject obj = jsonElement.getAsJsonObject();
        int wrappedSourceId = obj.getAsJsonPrimitive("wrapped_source_id").getAsInt();
        if (this.sacSerializer.getIdToSac().containsKey(wrappedSourceId)) {
            wrappedSac = this.sacSerializer.getIdToSac().get(wrappedSourceId);
        } else {
            JsonElement element = this.sacSerializer.idToJsonElement.get(wrappedSourceId);
            wrappedSac = (SourceAndConverter)this.sacSerializer.getGson().fromJson(element, SourceAndConverter.class);
        }
        if (wrappedSac == null) {
            System.err.println("Couldn't deserialize wrapped source");
            return null;
        }
        AffineTransform3D at3d = (AffineTransform3D)jsonDeserializationContext.deserialize(jsonElement.getAsJsonObject().get("affinetransform_fixed"), RealTransform.class);
        SourceAndConverter sac = new SourceAffineTransformer(wrappedSac, at3d).get();
        return sac;
    }
}

