/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.adapter.source;

import bdv.SpimSource;
import bdv.viewer.SourceAndConverter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Optional;
import mpicbg.spim.data.generic.AbstractSpimData;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.adapter.source.ISourceAdapter;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.services.ISourceAndConverterService;
import sc.fiji.bdvpg.services.SourceAndConverterAdapter;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

@Plugin(type=ISourceAdapter.class)
public class SpimSourceAdapter
implements ISourceAdapter<SpimSource> {
    SourceAndConverterAdapter sacSerializer;

    @Override
    public void setSacSerializer(SourceAndConverterAdapter sacSerializer) {
        this.sacSerializer = sacSerializer;
    }

    @Override
    public Class<SpimSource> getSourceClass() {
        return SpimSource.class;
    }

    @Override
    public JsonElement serialize(SourceAndConverter sac, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject obj = new JsonObject();
        SourceAndConverterService.SpimDataInfo sdi = (SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata(sac, "SPIMDATA");
        if (sdi == null) {
            System.err.println("Spim Source " + sac.getSpimSource().getName() + "  has no associated spimdata. Deserialization will fail.");
        } else {
            obj.add("spimdata", jsonSerializationContext.serialize((Object)sdi.asd));
            obj.addProperty("viewsetup", (Number)sdi.setupId);
        }
        return obj;
    }

    @Override
    public SourceAndConverter<?> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject obj = jsonElement.getAsJsonObject();
        AbstractSpimData asd = (AbstractSpimData)jsonDeserializationContext.deserialize(obj.get("spimdata"), AbstractSpimData.class);
        if (asd == null) {
            System.err.println("A BDV Dataset could not be serialized!");
            return null;
        }
        int setupId = obj.getAsJsonPrimitive("viewsetup").getAsInt();
        ISourceAndConverterService sacservice = SourceAndConverterServices.getSourceAndConverterService();
        Optional<SourceAndConverter> futureSac = sacservice.getSourceAndConverters().stream().filter(sac -> sacservice.containsMetadata((SourceAndConverter<?>)sac, "SPIMDATA")).filter(sac -> {
            SourceAndConverterService.SpimDataInfo sdi = (SourceAndConverterService.SpimDataInfo)sacservice.getMetadata((SourceAndConverter<?>)sac, "SPIMDATA");
            return sdi.asd.equals(asd) && sdi.setupId == setupId;
        }).findFirst();
        if (futureSac.isPresent()) {
            return futureSac.get();
        }
        System.err.println("Couldn't deserialize spim source from json element " + jsonElement.getAsString());
        return null;
    }
}

