/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.adapter.source;

import bdv.util.ResampledSource;
import bdv.viewer.Interpolation;
import bdv.viewer.SourceAndConverter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.adapter.source.ISourceAdapter;
import sc.fiji.bdvpg.services.SourceAndConverterAdapter;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceResampler;

@Plugin(type=ISourceAdapter.class)
public class ResampledSourceAdapter
implements ISourceAdapter<ResampledSource> {
    protected static final Logger logger = LoggerFactory.getLogger(ResampledSourceAdapter.class);
    SourceAndConverterAdapter sacSerializer;

    @Override
    public void setSacSerializer(SourceAndConverterAdapter sacSerializer) {
        this.sacSerializer = sacSerializer;
    }

    @Override
    public Class<ResampledSource> getSourceClass() {
        return ResampledSource.class;
    }

    @Override
    public JsonElement serialize(SourceAndConverter sac, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject obj = new JsonObject();
        ResampledSource source = (ResampledSource)sac.getSpimSource();
        obj.addProperty("type", ResampledSource.class.getSimpleName());
        obj.add("interpolate", jsonSerializationContext.serialize((Object)source.originInterpolation()));
        obj.addProperty("cache", Boolean.valueOf(source.isCached()));
        obj.addProperty("name", source.getName());
        obj.addProperty("mipmaps_reused", Boolean.valueOf(source.areMipmapsReused()));
        obj.addProperty("defaultMipmapLevel", (Number)source.getDefaultMipMapLevel());
        Integer idOrigin = this.sacSerializer.getSourceToId().get(source.getOriginalSource());
        Integer idModel = this.sacSerializer.getSourceToId().get(source.getModelResamplerSource());
        if (idOrigin == null) {
            logger.error("The resampled source " + source.getOriginalSource().getName() + " couldn't be serialized : origin source not identified.");
            return null;
        }
        if (idModel == null) {
            logger.error("The resampled source " + source.getOriginalSource().getName() + " couldn't be serialized : model source not identified.");
            return null;
        }
        obj.addProperty("origin_source_id", (Number)idOrigin);
        obj.addProperty("model_source_id", (Number)idModel);
        return obj;
    }

    @Override
    public SourceAndConverter<?> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        SourceAndConverter modelSac;
        JsonElement element;
        SourceAndConverter originSac;
        JsonObject obj = jsonElement.getAsJsonObject();
        int origin_source_id = obj.getAsJsonPrimitive("origin_source_id").getAsInt();
        int model_source_id = obj.getAsJsonPrimitive("model_source_id").getAsInt();
        Interpolation interpolation = (Interpolation)((Object)jsonDeserializationContext.deserialize(obj.get("interpolate"), Interpolation.class));
        boolean cache = obj.getAsJsonPrimitive("cache").getAsBoolean();
        String name = obj.getAsJsonPrimitive("name").getAsString();
        boolean reuseMipMaps = obj.getAsJsonPrimitive("mipmaps_reused").getAsBoolean();
        int defaultMipMapLevel = obj.getAsJsonPrimitive("defaultMipmapLevel").getAsInt();
        if (this.sacSerializer.getIdToSac().containsKey(origin_source_id)) {
            originSac = this.sacSerializer.getIdToSac().get(origin_source_id);
        } else {
            element = this.sacSerializer.idToJsonElement.get(origin_source_id);
            originSac = (SourceAndConverter)this.sacSerializer.getGson().fromJson(element, SourceAndConverter.class);
        }
        if (this.sacSerializer.getIdToSac().containsKey(model_source_id)) {
            modelSac = this.sacSerializer.getIdToSac().get(model_source_id);
        } else {
            element = this.sacSerializer.idToJsonElement.get(model_source_id);
            modelSac = (SourceAndConverter)this.sacSerializer.getGson().fromJson(element, SourceAndConverter.class);
        }
        if (originSac == null) {
            System.err.println("Couldn't deserialize origin source in Resampled Source");
            return null;
        }
        if (modelSac == null) {
            System.err.println("Couldn't deserialize model source in Resampled Source");
            return null;
        }
        return new SourceResampler(originSac, modelSac, name, reuseMipMaps, cache, interpolation.equals((Object)Interpolation.NLINEAR), defaultMipMapLevel).get();
    }
}

