/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.adapter;

import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.imglib2.display.ColorConverter;
import net.imglib2.type.numeric.ARGBType;
import org.scijava.InstantiableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.adapter.source.ISourceAdapter;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.display.ColorChanger;
import sc.fiji.persist.IObjectScijavaAdapterService;

public class SourceAndConverterAdapter
implements JsonSerializer<SourceAndConverter<?>>,
JsonDeserializer<SourceAndConverter<?>> {
    protected static final Logger logger = LoggerFactory.getLogger(SourceAndConverterAdapter.class);
    final sc.fiji.bdvpg.services.SourceAndConverterAdapter sacSerializer;
    final Map<Class<? extends Source<?>>, ISourceAdapter<?>> sourceSerializers = new HashMap();
    final Map<String, ISourceAdapter<?>> sourceSerializersFromName = new HashMap();

    public SourceAndConverterAdapter(sc.fiji.bdvpg.services.SourceAndConverterAdapter sacSerializer) {
        this.sacSerializer = sacSerializer;
        ((IObjectScijavaAdapterService)sacSerializer.getScijavaContext().getService(IObjectScijavaAdapterService.class)).getAdapters(ISourceAdapter.class).forEach(pi -> {
            try {
                ISourceAdapter adapter = (ISourceAdapter)pi.createInstance();
                adapter.setSacSerializer(sacSerializer);
                this.sourceSerializers.put(adapter.getSourceClass(), adapter);
                this.sourceSerializersFromName.put(adapter.getSourceClass().getName(), adapter);
            }
            catch (InstantiableException e) {
                e.printStackTrace();
            }
        });
    }

    public JsonElement serialize(SourceAndConverter sourceAndConverter, Type type, JsonSerializationContext jsonSerializationContext) {
        try {
            JsonObject obj = new JsonObject();
            obj.addProperty("source_name", sourceAndConverter.getSpimSource().getName());
            obj.addProperty("source_class", sourceAndConverter.getSpimSource().getClass().getName());
            obj.addProperty("converter_class", sourceAndConverter.getConverter().getClass().toString());
            obj.addProperty("source_id", (Number)this.sacSerializer.getSacToId().get(sourceAndConverter));
            if (sourceAndConverter.getConverter() instanceof ColorConverter) {
                ColorConverter colorConverter = (ColorConverter)sourceAndConverter.getConverter();
                obj.add("color", jsonSerializationContext.serialize((Object)colorConverter.getColor().get()));
                double min = SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(sourceAndConverter).getDisplayRangeMin();
                double max = SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(sourceAndConverter).getDisplayRangeMax();
                obj.addProperty("converter_setup_min", (Number)min);
                obj.addProperty("converter_setup_max", (Number)max);
            }
            HashMap stringMetaData = new HashMap();
            SourceAndConverterServices.getSourceAndConverterService().getMetadataKeys(sourceAndConverter).forEach(key -> {
                Object o = SourceAndConverterServices.getSourceAndConverterService().getMetadata(sourceAndConverter, (String)key);
                if (o instanceof String) {
                    stringMetaData.put(key, (String)o);
                }
            });
            JsonElement element = this.serializeSubClass(sourceAndConverter, (Type)((Object)SourceAndConverter.class), jsonSerializationContext);
            obj.add("sac", element);
            obj.add("string_metadata", jsonSerializationContext.serialize(stringMetaData));
            return obj;
        }
        catch (UnsupportedOperationException e) {
            logger.error("Could not serialize source " + sourceAndConverter.getSpimSource().getName() + " of class " + sourceAndConverter.getSpimSource().getClass().getName());
            return null;
        }
    }

    JsonElement serializeSubClass(SourceAndConverter<?> sourceAndConverter, Type type, JsonSerializationContext jsonSerializationContext) throws UnsupportedOperationException {
        if (!this.sourceSerializers.containsKey(sourceAndConverter.getSpimSource().getClass())) {
            logger.error("Unsupported serialisation of " + sourceAndConverter.getSpimSource().getClass());
            throw new UnsupportedOperationException();
        }
        return this.sourceSerializers.get(sourceAndConverter.getSpimSource().getClass()).serialize(sourceAndConverter, (Type)((Object)SourceAndConverter.class), jsonSerializationContext);
    }

    public SourceAndConverter<?> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        String sourceClass = jsonObject.getAsJsonPrimitive("source_class").getAsString();
        if (!this.sourceSerializersFromName.containsKey(sourceClass)) {
            logger.error("Unsupported deserialization of " + sourceClass);
            throw new UnsupportedOperationException();
        }
        SourceAndConverter<?> sac = this.sourceSerializersFromName.get(sourceClass).deserialize(jsonObject.get("sac"), (Type)((Object)SourceAndConverter.class), jsonDeserializationContext);
        if (sac != null) {
            if (jsonObject.getAsJsonPrimitive("color") != null) {
                int color = jsonObject.getAsJsonPrimitive("color").getAsInt();
                new ColorChanger(sac, new ARGBType(color)).run();
                SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(sac).setDisplayRange(jsonObject.getAsJsonPrimitive("converter_setup_min").getAsDouble(), jsonObject.getAsJsonPrimitive("converter_setup_max").getAsDouble());
            }
            int idSource = jsonObject.getAsJsonPrimitive("source_id").getAsInt();
            this.sacSerializer.getIdToSac().put(idSource, sac);
            this.sacSerializer.getSacToId().put(sac, idSource);
            this.sacSerializer.getSourceToId().put(sac.getSpimSource(), idSource);
            this.sacSerializer.getIdToSource().put(idSource, sac.getSpimSource());
            this.sacSerializer.alreadyDeSerializedSacs.add(idSource);
            Map stringMetaData = (Map)jsonDeserializationContext.deserialize(jsonObject.get("string_metadata"), Map.class);
            stringMetaData.keySet().forEach(key -> SourceAndConverterServices.getSourceAndConverterService().setMetadata(sac, (String)key, stringMetaData.get(key)));
            return sac;
        }
        return null;
    }
}

