/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import mpicbg.spim.data.generic.AbstractSpimData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.services.SourceAndConverterAdapter;
import sc.fiji.bdvpg.spimdata.exporter.XmlFromSpimDataExporter;
import sc.fiji.bdvpg.spimdata.importer.SpimDataFromXmlImporter;

public class AbstractSpimdataAdapter
implements JsonSerializer<AbstractSpimData<?>>,
JsonDeserializer<AbstractSpimData<?>> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractSpimData.class);
    final SourceAndConverterAdapter sacSerializer;
    int spimdataCounter = 0;

    public AbstractSpimdataAdapter(SourceAndConverterAdapter sacSerializer) {
        this.sacSerializer = sacSerializer;
    }

    public JsonElement serialize(AbstractSpimData asd, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject obj = new JsonObject();
        String dataLocation = (String)((SourceAndConverterService)this.sacSerializer.getScijavaContext().getService(SourceAndConverterService.class)).getMetadata(asd, "SPIM_DATA_LOCATION");
        if (dataLocation == null || dataLocation.equals("")) {
            dataLocation = new File(this.sacSerializer.getBasePath(), "_bdvdataset_" + this.spimdataCounter + ".xml").getAbsolutePath();
            while (new File(dataLocation).exists()) {
                ++this.spimdataCounter;
                dataLocation = new File(this.sacSerializer.getBasePath(), "_bdvdataset_" + this.spimdataCounter + ".xml").getAbsolutePath();
            }
            ++this.spimdataCounter;
            logger.info("Previously unsaved bdv dataset, saving it to " + dataLocation);
            new XmlFromSpimDataExporter(asd, dataLocation, this.sacSerializer.getScijavaContext()).run();
        }
        if (this.sacSerializer.useRelativePaths()) {
            dataLocation = new File(dataLocation).getName();
        }
        obj.addProperty("datalocation", dataLocation);
        return obj;
    }

    public AbstractSpimData<?> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        SourceAndConverterService sacService;
        List asds;
        String datalocation = jsonElement.getAsJsonObject().get("datalocation").getAsString();
        if (this.sacSerializer.useRelativePaths()) {
            datalocation = new File(this.sacSerializer.getBasePath(), datalocation).getAbsolutePath();
        }
        String finalDataLocation = datalocation;
        if (datalocation.endsWith(".qpath")) {
            logger.error("qpath project unhandled in deserialization!");
        }
        if ((asds = (sacService = (SourceAndConverterService)this.sacSerializer.getScijavaContext().getService(SourceAndConverterService.class)).getSpimDatasets().stream().filter(asd -> {
            Object location = sacService.getMetadata((AbstractSpimData)asd, "SPIM_DATA_LOCATION");
            return location != null && location.equals(finalDataLocation);
        }).collect(Collectors.toList())).size() == 0) {
            return new SpimDataFromXmlImporter(datalocation).get();
        }
        if (asds.size() == 1) {
            return (AbstractSpimData)asds.get(0);
        }
        logger.warn("Multiple spimdata with identical data location already in memory!");
        return (AbstractSpimData)asds.get(0);
    }
}

