/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava;

import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import org.scijava.Context;
import org.scijava.command.Command;
import org.scijava.command.CommandService;
import org.scijava.module.Module;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleRunner;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.PluginService;
import org.scijava.ui.swing.widget.SwingInputHarvester;
import org.scijava.ui.swing.widget.SwingInputPanel;
import org.scijava.widget.InputHarvester;
import org.scijava.widget.InputPanel;

public class ScijavaSwingUI {
    public static <C extends Command> JPanel getPanel(Context context, Class<C> scijavaCommand, Object ... args) {
        JPanel panel = null;
        try {
            Module module = ScijavaSwingUI.createModule(context, scijavaCommand, args);
            panel = ScijavaSwingUI.createModulePanel(context, module);
        }
        catch (ModuleException e) {
            e.printStackTrace();
        }
        return panel;
    }

    public static Module createModule(Context context, Class<? extends Command> commandClass, Object ... args) throws ModuleException {
        Module module = ((CommandService)context.getService(CommandService.class)).getCommand(commandClass).createModule();
        context.inject((Object)module);
        ScijavaSwingUI.setModuleInputs(module, args);
        ScijavaSwingUI.preprocessWithoutHarvesting(context, module);
        return module;
    }

    private static <M extends Module> void preprocessWithoutHarvesting(Context context, M module) {
        ModuleRunner moduleRunner = new ModuleRunner(context, module, ScijavaSwingUI.preprocessorsWithoutHarvesting(context), Collections.emptyList());
        moduleRunner.preProcess();
    }

    private static List<? extends PreprocessorPlugin> preprocessorsWithoutHarvesting(Context context) {
        List preprocessors = ((PluginService)context.getService(PluginService.class)).createInstancesOfType(PreprocessorPlugin.class);
        preprocessors.removeIf(preprocessor -> preprocessor instanceof InputHarvester);
        return preprocessors;
    }

    private static void setModuleInputs(Module module, Object[] args) {
        assert (args.length % 2 == 0);
        for (int i = 0; i < args.length - 1; i += 2) {
            String input = (String)args[i];
            module.setInput(input, args[i + 1]);
            module.resolveInput(input);
        }
    }

    public static JPanel createModulePanel(Context context, Module module) throws ModuleException {
        SwingInputHarvester swingInputHarvester = new SwingInputHarvester();
        context.inject((Object)swingInputHarvester);
        SwingInputPanel inputPanel = new SwingInputPanel();
        swingInputHarvester.buildPanel((InputPanel)inputPanel, module);
        return (JPanel)inputPanel.getComponent();
    }
}

