/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava;

import bdv.util.BdvHandle;
import bdv.util.BdvHandleFrame;
import java.awt.Component;
import java.awt.Container;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.scijava.Context;
import org.scijava.command.Command;
import org.scijava.command.CommandService;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BdvScijavaHelper {
    protected static final Logger logger = LoggerFactory.getLogger(BdvScijavaHelper.class);

    public static void clearBdvHandleMenuBar(BdvHandle bdvh) {
        if (bdvh instanceof BdvHandleFrame) {
            JMenuBar bdvMenuBar = ((BdvHandleFrame)bdvh).getBigDataViewer().getViewerFrame().getJMenuBar();
            int componentsNumber = bdvMenuBar.getComponentCount();
            for (int i = 0; i < componentsNumber; ++i) {
                bdvMenuBar.remove(0);
            }
            bdvMenuBar.revalidate();
            bdvMenuBar.updateUI();
        }
    }

    public static void addCommandToBdvHandleMenu(BdvHandle bdvh, Context ctx, Class<? extends Command> commandClass, int skipTopLevels, Object ... args) {
        Plugin plugin = commandClass.getDeclaredAnnotation(Plugin.class);
        BdvScijavaHelper.addActionToBdvHandleMenu(bdvh, plugin.menuPath(), skipTopLevels, () -> ((CommandService)ctx.getService(CommandService.class)).run(commandClass, true, args));
    }

    public static void addSeparator(BdvHandle bdvh, String pathHierarchy) {
        if (bdvh instanceof BdvHandleFrame) {
            JMenuBar bdvMenuBar = ((BdvHandleFrame)bdvh).getBigDataViewer().getViewerFrame().getJMenuBar();
            List<String> path = Arrays.stream(pathHierarchy.split(">")).map(String::trim).collect(Collectors.toList());
            path.add("Separator");
            JMenu jMenuItemRoot = BdvScijavaHelper.findOrCreateJMenu(bdvMenuBar, path);
            if (jMenuItemRoot != null) {
                JSeparator jSeparator = new JSeparator();
                ((Container)jMenuItemRoot).add(jSeparator);
                bdvMenuBar.updateUI();
            } else {
                logger.error("Could not find or create jmenu (" + bdvMenuBar + ", " + path + ")");
            }
        } else {
            logger.error("Cannot put command on menu : the bdvhandle is not a frame.");
        }
    }

    public static void addCommandToBdvHandleMenu(BdvHandle bdvh, Context ctx, String path, Class<? extends Command> commandClass, Object ... args) {
        BdvScijavaHelper.addActionToBdvHandleMenu(bdvh, path, 0, () -> ((CommandService)ctx.getService(CommandService.class)).run(commandClass, true, args));
    }

    public static void addActionToBdvHandleMenu(BdvHandle bdvh, String pathHierarchy, int skipTopLevels, Runnable runnable) {
        if (bdvh instanceof BdvHandleFrame) {
            JMenu jMenuItemRoot;
            JMenuBar bdvMenuBar = ((BdvHandleFrame)bdvh).getBigDataViewer().getViewerFrame().getJMenuBar();
            List<String> path = Arrays.stream(pathHierarchy.split(">")).map(String::trim).collect(Collectors.toList());
            if (skipTopLevels > 0) {
                path.subList(0, skipTopLevels).clear();
            }
            if ((jMenuItemRoot = BdvScijavaHelper.findOrCreateJMenu(bdvMenuBar, path)) != null) {
                JMenuItem jMenuItem = new JMenuItem(path.get(path.size() - 1));
                jMenuItem.addActionListener(e -> runnable.run());
                ((Container)jMenuItemRoot).add(jMenuItem);
                bdvMenuBar.updateUI();
            } else {
                logger.error("Could not find or create jmenu (" + bdvMenuBar + ", " + path + ")");
            }
        } else {
            logger.error("Cannot put command on menu : the bdvhandle is not a frame.");
        }
    }

    private static JMenu findOrCreateJMenu(JMenuBar bdvMenuBar, List<String> path) {
        JMenu jmenu;
        if (path.isEmpty()) {
            logger.error("No Path specified in find or create JMenu!");
        }
        if (path.size() == 1) {
            return null;
        }
        boolean found = false;
        int idx = 0;
        while (idx < bdvMenuBar.getMenuCount() && !found) {
            JMenu jmenuTest = bdvMenuBar.getMenu(idx);
            if (jmenuTest.getText().equals(path.get(0))) {
                found = true;
                continue;
            }
            ++idx;
        }
        if (found) {
            jmenu = bdvMenuBar.getMenu(idx);
        } else {
            jmenu = new JMenu(path.get(0));
            bdvMenuBar.add(jmenu);
        }
        path.remove(0);
        return BdvScijavaHelper.findOrCreateJMenu(jmenu, path);
    }

    private static JMenu findOrCreateJMenu(JMenu jMenu, List<String> path) {
        if (path.isEmpty()) {
            logger.error(" Reached unreachable statement !");
        }
        if (path.size() == 1) {
            return jMenu;
        }
        for (int idx = 0; idx < jMenu.getMenuComponentCount(); ++idx) {
            Component component = jMenu.getMenuComponent(idx);
            if (!(component instanceof JMenu)) continue;
            JMenu jmi = (JMenu)component;
            if (!path.get(0).equals(jmi.getText())) continue;
            path.remove(0);
            return BdvScijavaHelper.findOrCreateJMenu(jmi, path);
        }
        JMenu jm = new JMenu(path.get(0));
        jMenu.add(jm);
        path.remove(0);
        return BdvScijavaHelper.findOrCreateJMenu(jm, path);
    }
}

