/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.cache;

import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.LoaderCache;
import net.imglib2.cache.ref.WeakRefLoaderCache;
import sc.fiji.bdvpg.cache.AbstractGlobalCache;
import sc.fiji.bdvpg.cache.BoundedLinkedHashMapGlobalCache;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

public class GlobalLoaderCache<K, V>
implements LoaderCache<K, V> {
    private final LoaderCache<K, V> cache = new WeakRefLoaderCache();
    private final AbstractGlobalCache globalCache;
    private final Object source;
    private final int timepoint;
    private final int level;

    public GlobalLoaderCache(Object source, int timepoint, int level) {
        this.source = source;
        this.timepoint = timepoint;
        this.level = level;
        this.globalCache = SourceAndConverterServices.getSourceAndConverterService().getCache();
    }

    public GlobalLoaderCache(Object source) {
        this.source = source;
        this.timepoint = -1;
        this.level = -1;
        this.globalCache = SourceAndConverterServices.getSourceAndConverterService().getCache();
    }

    public V getIfPresent(K key) {
        Object value = this.cache.getIfPresent(key);
        if (value != null) {
            this.globalCache.touch(BoundedLinkedHashMapGlobalCache.getKey(this.source, this.timepoint, this.level, key), value);
        }
        return (V)value;
    }

    public V get(K key, CacheLoader<? super K, ? extends V> loader) throws ExecutionException {
        Object value = this.cache.get(key, loader);
        this.globalCache.put(BoundedLinkedHashMapGlobalCache.getKey(this.source, this.timepoint, this.level, key), value);
        return (V)value;
    }

    public void persist(K key) {
    }

    public void persistIf(Predicate<K> condition) {
    }

    public void persistAll() {
    }

    public void invalidate(K key) {
        this.cache.invalidate(key);
        this.globalCache.invalidate(BoundedLinkedHashMapGlobalCache.getKey(this.source, this.timepoint, this.level, key));
    }

    public void invalidateIf(long parallelismThreshold, Predicate<K> condition) {
        this.cache.invalidateIf(parallelismThreshold, condition);
        this.globalCache.invalidateIf(BoundedLinkedHashMapGlobalCache.getCondition(this.source, this.timepoint, this.level, condition));
    }

    public void invalidateAll(long parallelismThreshold) {
        this.cache.invalidateAll(parallelismThreshold);
    }
}

