/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.cache;

import java.lang.ref.WeakReference;

public class GlobalCacheKey {
    private final WeakReference<Object> source;
    private final int timepoint;
    private final int level;
    public final WeakReference<Object> key;
    final int hashcode;

    public GlobalCacheKey(Object source, int timepoint, int level, Object key) {
        this.source = new WeakReference<Object>(source);
        this.timepoint = timepoint;
        this.level = level;
        this.key = new WeakReference<Object>(key);
        int value = source.hashCode();
        value = 31 * value + level;
        value = 31 * value + key.hashCode();
        this.hashcode = value = 31 * value + timepoint;
    }

    public boolean partialEquals(Object source, int timepoint, int level) {
        if (this.source.get() == null) {
            return false;
        }
        if (this.key.get() == null) {
            return false;
        }
        return this.source.get() == source && this.timepoint == timepoint && this.level == level;
    }

    public boolean equals(Object other) {
        if (this.source.get() == null) {
            return false;
        }
        if (this.key.get() == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof GlobalCacheKey)) {
            return false;
        }
        GlobalCacheKey that = (GlobalCacheKey)other;
        return this.source.get() == that.source.get() && this.timepoint == that.timepoint && this.level == that.level && this.key.get().equals(that.key.get());
    }

    public int hashCode() {
        return this.hashcode;
    }
}

