/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.cache;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.cache.AbstractGlobalCache;
import sc.fiji.bdvpg.cache.BoundedLinkedHashMapGlobalCache;
import sc.fiji.bdvpg.cache.CaffeineGlobalCache;

public class GlobalCacheBuilder {
    static final Logger logger = LoggerFactory.getLogger(GlobalCacheBuilder.class);
    public static final String LINKED_HASH_MAP = "LinkedHashMap";
    public static final String CAFFEINE = "Caffeine";
    static final double defaultPolicyRatio = 0.5;
    private boolean log = false;
    private int msBetweenLog = 2000;
    private double memoryRatioForCache = 0.5;
    private long memoryInBytesForCache = -1L;
    private long memoryInBytesForEverythingElse = -1L;
    transient long maxAvailableMemoryInBytes;
    String cacheType = "Caffeine";

    protected GlobalCacheBuilder() {
        if (Runtime.getRuntime().maxMemory() == Long.MAX_VALUE) {
            logger.error("Cannot fetch maximum runtime memory! Maximal memory available set completely arbitrarily to 20 Gb");
            this.maxAvailableMemoryInBytes = 0x500000000L;
        } else {
            this.maxAvailableMemoryInBytes = (long)((double)Runtime.getRuntime().maxMemory() * 0.5);
        }
    }

    protected GlobalCacheBuilder(long maxAvailableMemoryInBytes) {
        this.maxAvailableMemoryInBytes = maxAvailableMemoryInBytes;
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public boolean getLog() {
        return this.log;
    }

    public int getMsBetweenLog() {
        return this.msBetweenLog;
    }

    public long getMemoryInBytesForCache() {
        return this.memoryInBytesForCache;
    }

    public long getMemoryInBytesForEverythingElse() {
        return this.memoryInBytesForEverythingElse;
    }

    public double getMemoryRatioForCache() {
        return this.memoryRatioForCache;
    }

    public static GlobalCacheBuilder builder() {
        return new GlobalCacheBuilder();
    }

    public static GlobalCacheBuilder builder(long explicitMaxMemoryUsable) {
        return new GlobalCacheBuilder(explicitMaxMemoryUsable);
    }

    public GlobalCacheBuilder log(int msBetweenLog) {
        this.log = true;
        this.msBetweenLog = msBetweenLog;
        return this;
    }

    public GlobalCacheBuilder maxSize(long size) {
        this.maxAvailableMemoryInBytes = size;
        return this;
    }

    public GlobalCacheBuilder caffeine() {
        this.cacheType = CAFFEINE;
        return this;
    }

    public GlobalCacheBuilder linkedHashMap() {
        this.cacheType = LINKED_HASH_MAP;
        return this;
    }

    public GlobalCacheBuilder memoryRatioForCache(double ratio) {
        this.memoryRatioForCache = ratio;
        this.memoryInBytesForCache = -1L;
        this.memoryInBytesForEverythingElse = -1L;
        return this;
    }

    public GlobalCacheBuilder memoryForCache(long nBytes) {
        this.memoryRatioForCache = -1.0;
        this.memoryInBytesForCache = nBytes;
        this.memoryInBytesForEverythingElse = -1L;
        return this;
    }

    public GlobalCacheBuilder memoryForEverythingElse(long nBytes) {
        this.memoryRatioForCache = -1.0;
        this.memoryInBytesForCache = -1L;
        this.memoryInBytesForEverythingElse = nBytes;
        return this;
    }

    public AbstractGlobalCache create() {
        long cacheSize;
        if (this.memoryRatioForCache > 0.0) {
            cacheSize = (long)(this.memoryRatioForCache * (double)this.maxAvailableMemoryInBytes);
        } else if (this.memoryInBytesForCache > 0L) {
            if (this.memoryInBytesForCache > this.maxAvailableMemoryInBytes) {
                logger.warn("You are setting a cache size (" + this.memoryInBytesForCache + ")which is higher than the total available memory from the JVM (" + this.maxAvailableMemoryInBytes + ")!");
            }
            cacheSize = this.memoryInBytesForCache;
        } else if (this.memoryInBytesForEverythingElse > 0L) {
            cacheSize = this.maxAvailableMemoryInBytes - this.memoryInBytesForEverythingElse;
            if (cacheSize < 0L) {
                logger.warn("You are setting a cache size of 0 bytes. Setting it back to default policy.");
                this.memoryRatioForCache = 0.5;
                cacheSize = (long)(this.memoryRatioForCache * (double)this.maxAvailableMemoryInBytes);
            }
        } else {
            logger.error("Unknown cache policy! Setting it back to default policy.");
            this.memoryRatioForCache = 0.5;
            cacheSize = (long)(this.memoryRatioForCache * (double)this.maxAvailableMemoryInBytes);
        }
        logger.info("Global cache set to " + (int)((double)cacheSize / 1048576.0) + " Mb, out of " + (int)((double)this.maxAvailableMemoryInBytes / 1048576.0) + " Mb available (" + (int)(100.0 * ((double)cacheSize / 1048576.0) / ((double)this.maxAvailableMemoryInBytes / 1048576.0)) + "%)");
        switch (this.cacheType) {
            case "Caffeine": {
                return new CaffeineGlobalCache(cacheSize, this.log, this.msBetweenLog);
            }
            case "LinkedHashMap": {
                return new BoundedLinkedHashMapGlobalCache(100, cacheSize, this.log, this.msBetweenLog);
            }
        }
        throw new UnsupportedOperationException("Cannot create cache of type " + this.cacheType);
    }
}

