/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Policy;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.cache.AbstractGlobalCache;
import sc.fiji.bdvpg.cache.GlobalCacheKey;

public class CaffeineGlobalCache
extends AbstractGlobalCache {
    static final Logger logger = LoggerFactory.getLogger(CaffeineGlobalCache.class);
    final Cache<GlobalCacheKey, Object> cache;
    final long maxCacheSize;

    CaffeineGlobalCache(long maxCacheSize, boolean log, int msBetweenLogs) {
        this.maxCacheSize = maxCacheSize;
        this.cache = Caffeine.newBuilder().maximumWeight(maxCacheSize).softValues().weigher((key, value) -> (int)AbstractGlobalCache.getWeight(value)).build();
        if (log) {
            TimerTask periodicLogger = new TimerTask(){

                @Override
                public void run() {
                    logger.info(CaffeineGlobalCache.this.toString());
                }
            };
            Timer time = new Timer();
            time.schedule(periodicLogger, 0L, (long)msBetweenLogs);
        }
    }

    @Override
    public void setMaxSize(long maxCacheSize) {
        throw new UnsupportedOperationException("Can't changed caffeine backed max cache size");
    }

    @Override
    public void put(GlobalCacheKey key, Object value) {
        this.cache.put((Object)key, value);
    }

    @Override
    public Object get(GlobalCacheKey key) throws ExecutionException {
        logger.error("Cannot use get");
        return null;
    }

    @Override
    public Object getIfPresent(GlobalCacheKey key) {
        return this.cache.getIfPresent((Object)key);
    }

    @Override
    public void invalidate(GlobalCacheKey key) {
        this.cache.invalidate((Object)key);
    }

    @Override
    public void invalidateIf(long parallelismThreshold, Predicate<GlobalCacheKey> condition) {
        throw new UnsupportedOperationException("Can't invalidate based on predicate");
    }

    @Override
    public void invalidateAll(long parallelismThreshold) {
        this.cache.invalidateAll();
    }

    @Override
    public long getMaxSize() {
        return this.maxCacheSize;
    }

    @Override
    public long getEstimatedSize() {
        return this.cache.estimatedSize() * 1000000L;
    }

    @Override
    public <V> void touch(GlobalCacheKey key, V value) {
        this.cache.getIfPresent((Object)key);
    }

    public String toString() {
        long totalBytes = ((Policy.Eviction)this.cache.policy().eviction().get()).weightedSize().getAsLong();
        return "Cache size : " + totalBytes / 0x100000L + " Mb (" + (int)(100.0 * (double)totalBytes / (double)this.maxCacheSize) + " %)";
    }
}

