/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.cache;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.cache.AbstractGlobalCache;
import sc.fiji.bdvpg.cache.GlobalCacheKey;

public class BoundedLinkedHashMapGlobalCache
extends AbstractGlobalCache {
    static final Logger logger = LoggerFactory.getLogger(BoundedLinkedHashMapGlobalCache.class);
    final SoftRefs cache;

    BoundedLinkedHashMapGlobalCache(int iniSize, long maxCacheSize, boolean log, int msBetweenLogs) {
        this.cache = new SoftRefs(iniSize, maxCacheSize);
        if (log) {
            TimerTask periodicLogger = new TimerTask(){

                @Override
                public void run() {
                    logger.info(BoundedLinkedHashMapGlobalCache.this.toString());
                }
            };
            Timer time = new Timer();
            time.schedule(periodicLogger, 0L, (long)msBetweenLogs);
        }
    }

    @Override
    public void setMaxSize(long maxCacheSize) {
        this.cache.setMaxCost(maxCacheSize);
    }

    @Override
    public void put(GlobalCacheKey key, Object value) {
        this.cache.touch(key, value);
    }

    @Override
    public Object get(GlobalCacheKey key) throws ExecutionException {
        return this.cache.get(key);
    }

    @Override
    public Object getIfPresent(GlobalCacheKey key) {
        return this.cache.get(key);
    }

    @Override
    public void invalidate(GlobalCacheKey key) {
        this.cache.remove(key);
    }

    @Override
    public void invalidateIf(long parallelismThreshold, Predicate<GlobalCacheKey> condition) {
        this.cache.keySet().removeIf(condition);
    }

    @Override
    public void invalidateAll(long parallelismThreshold) {
        this.cache.clear();
    }

    @Override
    public long getMaxSize() {
        return this.cache.getMaxCost();
    }

    @Override
    public long getEstimatedSize() {
        return this.cache.getCost();
    }

    @Override
    public <V> void touch(GlobalCacheKey key, V value) {
        this.cache.touch(key, value);
    }

    public String toString() {
        return "Cache size : " + this.cache.getCost() / 0x100000L + " Mb (" + (int)(100.0 * (double)this.cache.getCost() / (double)this.cache.getMaxCost()) + " %)";
    }

    static class SoftRefs
    extends LinkedHashMap<GlobalCacheKey, SoftReference<Object>> {
        private static final long serialVersionUID = 1L;
        private long maxCost;
        AtomicLong totalWeight = new AtomicLong();
        HashMap<GlobalCacheKey, Long> cost = new HashMap();

        public SoftRefs(int iniSize, long maxCost) {
            super(iniSize, 0.75f, true);
            this.maxCost = maxCost;
        }

        public void setMaxCost(long maxCost) {
            this.maxCost = maxCost;
        }

        public long getCost() {
            return this.totalWeight.get();
        }

        public long getMaxCost() {
            return this.maxCost;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<GlobalCacheKey, SoftReference<Object>> eldest) {
            if (this.totalWeight.get() > this.maxCost) {
                this.totalWeight.addAndGet(-this.cost.get(eldest.getKey()).longValue());
                this.cost.remove(eldest.getKey());
                eldest.getValue().clear();
                return true;
            }
            return false;
        }

        public synchronized void touch(GlobalCacheKey key, Object value) {
            SoftReference ref = (SoftReference)this.get(key);
            if (ref == null) {
                long costValue = AbstractGlobalCache.getWeight(value);
                this.totalWeight.addAndGet(costValue);
                this.cost.put(key, costValue);
                this.put(key, new SoftReference<Object>(value));
            } else if (ref.get() == null) {
                this.put(key, new SoftReference<Object>(value));
            }
        }

        @Override
        public synchronized void clear() {
            for (SoftReference ref : this.values()) {
                ref.clear();
            }
            this.totalWeight.set(0L);
            this.cost.clear();
            super.clear();
        }
    }
}

