/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.cache;

import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import net.imglib2.cache.Cache;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.img.basictypeaccess.FloatAccess;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.img.basictypeaccess.ShortAccess;
import net.imglib2.img.cell.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.cache.GlobalCacheKey;

public abstract class AbstractGlobalCache
implements Cache<GlobalCacheKey, Object> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractGlobalCache.class);

    public static <K> Predicate<GlobalCacheKey> getCondition(Object source, int timepoint, int level, Predicate<K> condition) {
        return key -> key.partialEquals(source, timepoint, level) && condition.test(key.key.get());
    }

    public abstract void setMaxSize(long var1);

    public static GlobalCacheKey getKey(Object source, int timepoint, int level, Object key) {
        return new GlobalCacheKey(source, timepoint, level, key);
    }

    public abstract void put(GlobalCacheKey var1, Object var2);

    public abstract Object get(GlobalCacheKey var1) throws ExecutionException;

    public abstract Object getIfPresent(GlobalCacheKey var1);

    public void persist(GlobalCacheKey key) {
    }

    public void persistIf(Predicate<GlobalCacheKey> condition) {
    }

    public void persistAll() {
    }

    public abstract void invalidate(GlobalCacheKey var1);

    public abstract void invalidateIf(long var1, Predicate<GlobalCacheKey> var3);

    public abstract void invalidateAll(long var1);

    public abstract long getMaxSize();

    static long getWeight(Object object) {
        if (object instanceof Cell) {
            Cell cell = (Cell)object;
            Object data = cell.getData();
            if (ShortAccess.class.isInstance(data)) {
                return 2L * cell.size();
            }
            if (ByteAccess.class.isInstance(data)) {
                return cell.size();
            }
            if (FloatAccess.class.isInstance(data)) {
                return 4L * cell.size();
            }
            if (IntAccess.class.isInstance(data)) {
                return 4L * cell.size();
            }
            logger.info("Unknown data class of cell object " + data.getClass());
            return cell.size();
        }
        logger.info("Unknown class of cached object " + object.getClass());
        return 1L;
    }

    public abstract long getEstimatedSize();

    public abstract <V> void touch(GlobalCacheKey var1, V var2);
}

