/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bvv;

import bvv.vistools.BvvHandle;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.scijava.cache.CacheService;
import org.scijava.object.ObjectService;

public class BvvHandleHelper {
    public static JFrame getJFrame(BvvHandle bvvh) {
        return (JFrame)SwingUtilities.getWindowAncestor((Component)bvvh.getViewerPanel());
    }

    public static void setBvvHandleCloseOperation(final BvvHandle bvvh, final CacheService cs, final ObjectService os, boolean putWindowOnTop) {
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor((Component)bvvh.getViewerPanel());
        topFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                os.removeObject((Object)bvvh);
            }

            @Override
            public void windowActivated(WindowEvent e) {
                super.windowActivated(e);
                cs.put((Object)"LAST_ACTIVE_BVVH", new WeakReference<BvvHandle>(bvvh));
            }
        });
        if (putWindowOnTop) {
            cs.put((Object)"LAST_ACTIVE_BVVH", new WeakReference<BvvHandle>(bvvh));
        }
    }

    public static void activateWindow(BvvHandle bvvh) {
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor((Component)bvvh.getViewerPanel());
        topFrame.toFront();
        topFrame.requestFocus();
    }

    public static void closeWindow(BvvHandle bvvh) {
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor((Component)bvvh.getViewerPanel());
        topFrame.dispatchEvent(new WindowEvent(topFrame, 201));
    }

    public static void setWindowTitle(BvvHandle bvvh, String title) {
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor((Component)bvvh.getViewerPanel());
        topFrame.setTitle(title);
    }

    public static String getWindowTitle(BvvHandle bvvh) {
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor((Component)bvvh.getViewerPanel());
        return topFrame.getTitle();
    }

    public static String getUniqueWindowTitle(ObjectService os, String iniTitle) {
        List bvvs = os.getObjects(BvvHandle.class);
        String uniqueTitle = iniTitle;
        boolean duplicateExist = bvvs.stream().anyMatch(bvv -> bvv.toString().equals(iniTitle) || BvvHandleHelper.getWindowTitle(bvv).equals(iniTitle));
        while (duplicateExist) {
            if (uniqueTitle.matches(".+(_)\\d+")) {
                int idx = Integer.parseInt(uniqueTitle.substring(uniqueTitle.lastIndexOf("_") + 1));
                uniqueTitle = uniqueTitle.substring(0, uniqueTitle.lastIndexOf("_") + 1);
                uniqueTitle = uniqueTitle + String.format("%02d", idx + 1);
            } else {
                uniqueTitle = uniqueTitle + "_00";
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String uTTest = uniqueTitle;
            duplicateExist = bvvs.stream().anyMatch(bvv -> bvv.toString().equals(uTTest) || BvvHandleHelper.getWindowTitle(bvv).equals(uTTest));
        }
        return uniqueTitle;
    }
}

