/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bvv;

import bvv.vistools.BvvFunctions;
import bvv.vistools.BvvHandle;
import bvv.vistools.BvvOptions;
import bvv.vistools.BvvStackSource;
import java.util.function.Supplier;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.realtransform.AffineTransform3D;
import sc.fiji.bdvpg.bdv.navigate.TimepointAdapterAdder;
import sc.fiji.bdvpg.viewers.ViewerAdapter;

public class BvvCreator
implements Runnable,
Supplier<BvvHandle> {
    private BvvOptions bvvOptions;
    private final int numTimePoints;

    public BvvCreator() {
        this.bvvOptions = BvvOptions.options();
        this.numTimePoints = 1;
    }

    public BvvCreator(BvvOptions bvvOptions) {
        this.bvvOptions = bvvOptions;
        this.numTimePoints = 1;
    }

    public BvvCreator(BvvOptions bvvOptions, int numTimePoints) {
        this.bvvOptions = bvvOptions;
        this.numTimePoints = numTimePoints;
    }

    @Override
    public void run() {
    }

    @Override
    public BvvHandle get() {
        ArrayImg dummyImg = ArrayImgs.unsignedShorts((long[])new long[]{2L, 2L, 2L});
        dummyImg.forEach(t -> t.set(0));
        this.bvvOptions = this.bvvOptions.sourceTransform(new AffineTransform3D());
        BvvStackSource bss = BvvFunctions.show((RandomAccessibleInterval)dummyImg, (String)"dummy", (BvvOptions)this.bvvOptions);
        BvvHandle bvv = bss.getBvvHandle();
        bvv.getViewerPanel().setNumTimepoints(this.numTimePoints);
        new TimepointAdapterAdder(new ViewerAdapter(bvv)).run();
        return bvv;
    }
}

