/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.behaviour;

import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.commons.lang.ArrayUtils;
import org.scijava.ui.behaviour.ClickBehaviour;
import sc.fiji.bdvpg.scijava.services.ui.SourceAndConverterPopupMenu;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class SourceAndConverterContextMenuClickBehaviour
implements ClickBehaviour {
    final BdvHandle bdv;
    final Supplier<Collection<SourceAndConverter<?>>> sourcesSupplier;
    String[] popupActions;

    public SourceAndConverterContextMenuClickBehaviour(BdvHandle bdv) {
        this(bdv, () -> SourceAndConverterHelper.getSourceAndConvertersAtCurrentMousePosition(bdv));
    }

    public SourceAndConverterContextMenuClickBehaviour(BdvHandle bdv, String[] popupActions) {
        this(bdv, () -> SourceAndConverterHelper.getSourceAndConvertersAtCurrentMousePosition(bdv), popupActions);
    }

    public SourceAndConverterContextMenuClickBehaviour(BdvHandle bdv, Supplier<Collection<SourceAndConverter<?>>> sourcesSupplier) {
        this(bdv, sourcesSupplier, SourceAndConverterPopupMenu.defaultPopupActions);
    }

    public SourceAndConverterContextMenuClickBehaviour(BdvHandle bdv, Supplier<Collection<SourceAndConverter<?>>> sourcesSupplier, String[] popupActions) {
        this.bdv = bdv;
        this.sourcesSupplier = sourcesSupplier;
        this.popupActions = popupActions;
    }

    public void click(int x, int y) {
        this.showPopupMenu(this.bdv, x, y);
    }

    private void showPopupMenu(BdvHandle bdv, int x, int y) {
        ArrayList sacs = new ArrayList(this.sourcesSupplier.get());
        SourceAndConverterPopupMenu popupMenu = new SourceAndConverterPopupMenu(() -> sacs.toArray(new SourceAndConverter[0]), this.popupActions);
        popupMenu.getPopup().show(bdv.getViewerPanel().getDisplay(), x, y);
    }

    public synchronized void removeAction(String name) {
        int index = ArrayUtils.indexOf((Object[])this.popupActions, (Object)name);
        if (index != -1) {
            this.popupActions = (String[])ArrayUtils.remove((Object[])this.popupActions, (int)index);
        }
    }

    public synchronized void addAction(String name) {
        int index = ArrayUtils.indexOf((Object[])this.popupActions, (Object)name);
        if (index == -1) {
            this.popupActions = (String[])ArrayUtils.add((Object[])this.popupActions, (Object)name);
        }
    }
}

