/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.behaviour;

import bdv.util.BdvHandle;
import ch.epfl.biop.bdv.select.SourceSelectorBehaviour;
import ch.epfl.biop.bdv.select.ToggleListener;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.ClickBehaviour;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Behaviours;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.bdv.config.BdvSettingsGUISetter;
import sc.fiji.bdvpg.behaviour.SourceAndConverterContextMenuClickBehaviour;
import sc.fiji.bdvpg.scijava.command.bdv.BdvSourcesRemoverCommand;
import sc.fiji.bdvpg.scijava.command.bdv.BdvSourcesShowCommand;
import sc.fiji.bdvpg.scijava.command.source.BasicTransformerCommand;
import sc.fiji.bdvpg.scijava.command.source.InteractiveBrightnessAdjusterCommand;
import sc.fiji.bdvpg.scijava.command.source.SourceColorChangerCommand;
import sc.fiji.bdvpg.scijava.command.source.SourcesInvisibleMakerCommand;
import sc.fiji.bdvpg.scijava.command.source.SourcesRemoverCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

public class EditorBehaviourInstaller
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(EditorBehaviourInstaller.class);
    final SourceSelectorBehaviour ssb;
    final BdvHandle bdvh;
    private ToggleListener toggleListener;
    final String editorActionsPath;

    public String[] getEditorPopupActions() {
        File f = BdvSettingsGUISetter.getActionFile(this.editorActionsPath, "editor");
        String[] popupActions = new String[]{SourceAndConverterService.getCommandName(BdvSourcesShowCommand.class), SourceAndConverterService.getCommandName(BasicTransformerCommand.class), SourceAndConverterService.getCommandName(BdvSourcesRemoverCommand.class), "Inspect Sources", "PopupLine", SourceAndConverterService.getCommandName(SourcesInvisibleMakerCommand.class), SourceAndConverterService.getCommandName(InteractiveBrightnessAdjusterCommand.class), SourceAndConverterService.getCommandName(SourceColorChangerCommand.class), "PopupLine", SourceAndConverterService.getCommandName(SourcesRemoverCommand.class)};
        if (f.exists()) {
            try {
                Gson gson = new Gson();
                popupActions = (String[])gson.fromJson((Reader)new FileReader(f.getAbsoluteFile()), String[].class);
                if (popupActions == null || popupActions.length == 0) {
                    popupActions = new String[]{"Warning: Empty " + f.getAbsolutePath() + " config file."};
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            File fdefault = new File(f.getAbsolutePath() + ".default.txt");
            if (fdefault.exists()) {
                try {
                    Gson gson = new Gson();
                    popupActions = (String[])gson.fromJson((Reader)new FileReader(fdefault.getAbsoluteFile()), String[].class);
                    if (popupActions == null || popupActions.length == 0) {
                        popupActions = new String[]{"Warning: Empty " + fdefault.getAbsolutePath() + " config file."};
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                logger.error("Bdv Playground actions settings File " + f.getAbsolutePath() + " does not exist.");
                logger.error("Bdv Playground default actions settings File " + fdefault.getAbsolutePath() + " does not exist.");
            }
        }
        return popupActions;
    }

    public EditorBehaviourInstaller(SourceSelectorBehaviour ssb, String context) {
        this.ssb = ssb;
        this.bdvh = ssb.getBdvHandle();
        this.editorActionsPath = context;
    }

    @Override
    public void run() {
        final Behaviours editor = new Behaviours((InputTriggerAdder.Factory)new InputTriggerConfig(), new String[0]);
        ClickBehaviour delete = (x, y) -> this.bdvh.getViewerPanel().state().removeSources(this.ssb.getSelectedSources());
        editor.behaviour((Behaviour)delete, "remove-sources-from-bdv", new String[]{"DELETE"});
        editor.behaviour((Behaviour)new SourceAndConverterContextMenuClickBehaviour(this.bdvh, () -> ((SourceSelectorBehaviour)this.ssb).getSelectedSources(), this.getEditorPopupActions()), "Sources Context Menu", new String[]{"button3"});
        this.toggleListener = new ToggleListener(){

            public void isEnabled() {
                EditorBehaviourInstaller.this.bdvh.getViewerPanel().showMessage("Editor Mode");
                editor.install(EditorBehaviourInstaller.this.bdvh.getTriggerbindings(), "sources-editor");
            }

            public void isDisabled() {
                EditorBehaviourInstaller.this.bdvh.getViewerPanel().showMessage("Navigation Mode");
                EditorBehaviourInstaller.this.bdvh.getTriggerbindings().removeInputTriggerMap("sources-editor");
                EditorBehaviourInstaller.this.bdvh.getTriggerbindings().removeBehaviourMap("sources-editor");
            }
        };
        this.ssb.addToggleListener(this.toggleListener);
        SourceAndConverterServices.getBdvDisplayService().setDisplayMetadata(this.bdvh, EditorBehaviourInstaller.class.getSimpleName(), this);
    }

    public ToggleListener getToggleListener() {
        return this.toggleListener;
    }
}

