/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv.supplier;

import bdv.util.BdvFunctions;
import bdv.util.BdvHandle;
import bdv.util.BdvOptions;
import bdv.util.BdvStackSource;
import bdv.viewer.Interpolation;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.realtransform.AffineTransform3D;
import sc.fiji.bdvpg.bdv.navigate.TimepointAdapterAdder;
import sc.fiji.bdvpg.bdv.supplier.IBdvSupplier;
import sc.fiji.bdvpg.bdv.supplier.SerializableBdvOptions;

public class DefaultBdvSupplier
implements IBdvSupplier {
    public final SerializableBdvOptions sOptions;

    public DefaultBdvSupplier(SerializableBdvOptions sOptions) {
        this.sOptions = sOptions;
    }

    @Override
    public BdvHandle get() {
        BdvOptions options = this.sOptions.getBdvOptions();
        ArrayImg dummyImg = ArrayImgs.bytes((long[])new long[]{2L, 2L, 2L});
        options = options.sourceTransform(new AffineTransform3D());
        BdvStackSource bss = BdvFunctions.show((RandomAccessibleInterval)dummyImg, (String)"dummy", (BdvOptions)options);
        BdvHandle bdv = bss.getBdvHandle();
        if (this.sOptions.interpolate) {
            bdv.getViewerPanel().setInterpolation(Interpolation.NLINEAR);
        }
        bdv.getViewerPanel().state().removeSource(bdv.getViewerPanel().state().getCurrentSource());
        bdv.getViewerPanel().setNumTimepoints(this.sOptions.numTimePoints);
        new TimepointAdapterAdder(bdv).run();
        return bdv;
    }
}

