/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv.sourceandconverter;

import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import java.util.function.Consumer;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

public class SourceRemover
implements Runnable,
Consumer<SourceAndConverter<?>[]> {
    final SourceAndConverter<?> sacIn;
    final BdvHandle bdvh;

    public SourceRemover(BdvHandle bdvh, SourceAndConverter<?> sacIn) {
        this.sacIn = sacIn;
        this.bdvh = bdvh;
    }

    public SourceRemover(SourceAndConverter<?> sacIn) {
        this.sacIn = sacIn;
        this.bdvh = null;
    }

    public SourceRemover() {
        this.sacIn = null;
        this.bdvh = null;
    }

    @Override
    public void run() {
        this.accept(this.sacIn);
    }

    @Override
    public void accept(SourceAndConverter ... sacs) {
        if (this.bdvh == null) {
            SourceAndConverterServices.getBdvDisplayService().removeFromAllBdvs(sacs);
        } else {
            SourceAndConverterServices.getBdvDisplayService().remove(this.bdvh, sacs);
        }
    }
}

