/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv.overlay;

import bdv.util.Bdv;
import bdv.util.BdvFunctions;
import bdv.util.BdvHandle;
import bdv.util.BdvOptions;
import bdv.util.BdvOverlay;
import bdv.util.BdvOverlaySource;
import bdv.viewer.ViewerStateChangeListener;
import java.awt.Font;
import javax.swing.SwingUtilities;
import sc.fiji.bdvpg.bdv.overlay.SourceNameOverlay;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class SourceNameOverlayAdder
implements Runnable {
    final BdvHandle bdvh;
    SourceNameOverlay nameOverlay;
    BdvOverlaySource bos;
    final Font font;
    final ViewerStateChangeListener changeListener = viewerStateChange -> this.updatePositions();

    public SourceNameOverlayAdder(BdvHandle bdvh, Font font) {
        this.bdvh = bdvh;
        this.font = font;
    }

    @Override
    public void run() {
        this.nameOverlay = new SourceNameOverlay(this.bdvh.getViewerPanel(), this.font, SourceAndConverterHelper::sortDefault);
        this.addToBdv();
    }

    void updatePositions() {
        this.nameOverlay.update();
    }

    public BdvHandle getBdvh() {
        return this.bdvh;
    }

    public void removeFromBdv() {
        SwingUtilities.invokeLater(() -> {
            this.bdvh.getViewerPanel().state().changeListeners().remove((Object)this.changeListener);
            this.bos.removeFromBdv();
            this.bdvh.getViewerPanel().revalidate();
        });
    }

    public void addToBdv() {
        SwingUtilities.invokeLater(() -> {
            int nTimepointIni = this.bdvh.getViewerPanel().state().getNumTimepoints();
            int iTimePoint = this.bdvh.getViewerPanel().state().getCurrentTimepoint();
            this.bos = BdvFunctions.showOverlay((BdvOverlay)this.nameOverlay, (String)"Sources names", (BdvOptions)BdvOptions.options().addTo((Bdv)this.bdvh));
            this.bdvh.getViewerPanel().state().changeListeners().add((Object)this.changeListener);
            this.bdvh.getViewerPanel().state().setNumTimepoints(nTimepointIni);
            this.bdvh.getViewerPanel().state().setCurrentTimepoint(iTimePoint);
        });
    }
}

