/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv.overlay;

import bdv.tools.boundingbox.RenderBoxHelper;
import bdv.tools.boundingbox.TransformedBox;
import bdv.util.BdvOverlay;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineTransform3D;

public class SourceNameOverlay
extends BdvOverlay {
    final ViewerPanel viewer;
    private int canvasWidth;
    private int canvasHeight;
    private List<SourceBoxOverlay> sourcesBoxOverlay = new ArrayList<SourceBoxOverlay>();
    final Font font;
    final Function<SourceAndConverter<?>[], SourceAndConverter<?>[]> sorter;

    public SourceNameOverlay(ViewerPanel viewer, Font font, Function<SourceAndConverter<?>[], SourceAndConverter<?>[]> sorter) {
        this.viewer = viewer;
        this.font = font;
        this.sorter = sorter;
        this.update();
    }

    public synchronized void draw(Graphics2D g) {
        HashMap occupied = new HashMap();
        g.setFont(this.font);
        if (this.info != null) {
            g.setColor(new Color(this.info.getColor().get()));
        } else {
            g.setColor(Color.GRAY);
        }
        for (SourceBoxOverlay source : this.sourcesBoxOverlay) {
            source.drawSourceNameOverlay(g, occupied);
        }
    }

    public void setCanvasSize(int width, int height) {
        this.canvasWidth = width;
        this.canvasHeight = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        SourceAndConverter<?>[] sorted;
        ArrayList<SourceBoxOverlay> newSourcesBoxOverlay = new ArrayList<SourceBoxOverlay>();
        Set<SourceAndConverter<?>> sources = this.viewer.state().getVisibleSources();
        if (sources != null && sources.size() > 0 && this.sorter != null && (sorted = this.sorter.apply(sources.toArray(new SourceAndConverter[0]))) != null && sorted.length > 0) {
            for (SourceAndConverter<?> sac : sorted) {
                if (sac.getSpimSource().getSource(this.viewer.state().getCurrentTimepoint(), 0) == null) continue;
                newSourcesBoxOverlay.add(new SourceBoxOverlay(sac));
            }
        }
        List<SourceBoxOverlay> list = this.sourcesBoxOverlay;
        synchronized (list) {
            this.sourcesBoxOverlay = newSourcesBoxOverlay;
        }
    }

    private static int getStringWidth(String str, Graphics2D g2d) {
        FontMetrics fontMetrics = g2d.getFontMetrics();
        return fontMetrics.stringWidth(str);
    }

    private Map<Integer, Set<Integer>> displayNameAt(SourceAndConverter<?> sac, Graphics2D graphics, double xp, double yp, String name, Map<Integer, Set<Integer>> occupied) {
        double binSizeX = 100.0;
        double binSizeY = this.font.getSize();
        int binX = (int)(xp / binSizeX);
        int binY = (int)(yp / binSizeY);
        boolean shiftX = false;
        int shiftY = 0;
        if (!occupied.containsKey(binX)) {
            occupied.put(binX, new HashSet());
        }
        Set<Integer> occupiedY = occupied.get(binX);
        while (occupiedY.contains(binY)) {
            ++binY;
            shiftY = (int)((double)shiftY + binSizeY);
        }
        occupiedY.add(binY);
        String str = sac.getSpimSource().getName();
        graphics.drawString(str, (int)(xp + (double)shiftX - (double)SourceNameOverlay.getStringWidth(str, graphics) / 2.0), (int)(yp + (double)shiftY));
        return occupied;
    }

    class SourceBoxOverlay
    implements TransformedBox {
        final SourceAndConverter<?> sac;
        final RenderBoxHelper rbh;

        public SourceBoxOverlay(SourceAndConverter<?> sac) {
            this.sac = sac;
            this.rbh = new RenderBoxHelper();
        }

        private Map<Integer, Set<Integer>> drawSourceNameOverlay(Graphics2D graphics, Map<Integer, Set<Integer>> occupied) {
            GeneralPath front = new GeneralPath();
            GeneralPath back = new GeneralPath();
            GeneralPath intersection = new GeneralPath();
            RealInterval interval = this.getInterval();
            if (interval != null) {
                double ox = (double)SourceNameOverlay.this.canvasWidth / 2.0;
                double oy = (double)SourceNameOverlay.this.canvasHeight / 2.0;
                AffineTransform3D viewerTransform = new AffineTransform3D();
                SourceNameOverlay.this.viewer.state().getViewerTransform(viewerTransform);
                AffineTransform3D transform = new AffineTransform3D();
                this.getTransform(transform);
                transform.preConcatenate(viewerTransform);
                this.rbh.setOrigin(ox, oy);
                this.rbh.setScale(1.0);
                this.rbh.renderBox(interval, transform, front, back, intersection);
                Rectangle screen = new Rectangle(0, 0, SourceNameOverlay.this.canvasWidth, SourceNameOverlay.this.canvasHeight);
                Rectangle rectBounds = intersection.getBounds();
                if (rectBounds.x + rectBounds.width > 0 && rectBounds.x < SourceNameOverlay.this.canvasWidth && rectBounds.y + rectBounds.height > 0 && rectBounds.y < SourceNameOverlay.this.canvasHeight) {
                    Area a = new Area(intersection);
                    a.intersect(new Area(screen));
                    double cx = a.getBounds2D().getCenterX();
                    double cy = a.getBounds2D().getCenterY();
                    occupied = SourceNameOverlay.this.displayNameAt(this.sac, graphics, cx, cy, this.sac.getSpimSource().getName(), occupied);
                }
            }
            return occupied;
        }

        @Override
        public RealInterval getInterval() {
            long[] dims = new long[3];
            int currentTimePoint = SourceNameOverlay.this.viewer.state().getCurrentTimepoint();
            if (this.sac.getSpimSource().isPresent(currentTimePoint)) {
                this.sac.getSpimSource().getSource(currentTimePoint, 0).dimensions(dims);
                return new FinalRealInterval(new double[]{-0.5, -0.5, -0.5}, new double[]{(double)dims[0] - 0.5, (double)dims[1] - 0.5, (double)dims[2] - 0.5});
            }
            return null;
        }

        @Override
        public void getTransform(AffineTransform3D transform) {
            this.sac.getSpimSource().getSourceTransform(SourceNameOverlay.this.viewer.state().getCurrentTimepoint(), 0, transform);
        }
    }
}

