/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv.navigate;

import bdv.util.BdvHandle;
import bdv.viewer.animate.SimilarityTransformAnimator;
import net.imglib2.realtransform.AffineTransform3D;

public class ViewerTransformChanger
implements Runnable {
    private final BdvHandle bdvHandle;
    private AffineTransform3D transform;
    private final boolean concatenateToCurrentTransform;
    private final int animationDurationMillis;

    public ViewerTransformChanger(BdvHandle bdvHandle, AffineTransform3D transform, boolean concatenateToCurrentTransform) {
        this.bdvHandle = bdvHandle;
        this.transform = transform;
        this.concatenateToCurrentTransform = concatenateToCurrentTransform;
        this.animationDurationMillis = 0;
    }

    public ViewerTransformChanger(BdvHandle bdvHandle, AffineTransform3D transform, boolean concatenateToCurrentTransform, int animationDurationMillis) {
        this.bdvHandle = bdvHandle;
        this.transform = transform;
        this.concatenateToCurrentTransform = concatenateToCurrentTransform;
        this.animationDurationMillis = animationDurationMillis;
    }

    @Override
    public void run() {
        if (this.concatenateToCurrentTransform) {
            AffineTransform3D view = new AffineTransform3D();
            this.bdvHandle.getViewerPanel().state().getViewerTransform(view);
            this.transform = view.concatenate(this.transform);
        }
        if (this.animationDurationMillis <= 0) {
            this.bdvHandle.getViewerPanel().state().setViewerTransform(this.transform);
        } else {
            AffineTransform3D currentViewerTransform = new AffineTransform3D();
            this.bdvHandle.getViewerPanel().state().getViewerTransform(currentViewerTransform);
            SimilarityTransformAnimator similarityTransformAnimator = new SimilarityTransformAnimator(currentViewerTransform, this.transform, 0.0, 0.0, this.animationDurationMillis);
            this.bdvHandle.getViewerPanel().setTransformAnimator(similarityTransformAnimator);
        }
    }
}

