/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv.navigate;

import bdv.util.Affine3DHelpers;
import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.imglib2.FinalRealInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Intervals;
import net.imglib2.util.LinAlgHelpers;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.viewers.ViewerAdapter;

public class ViewerTransformAdjuster
implements Runnable {
    private final ViewerAdapter handle;
    private final SourceAndConverter<?>[] sources;

    public ViewerTransformAdjuster(BdvHandle bdvHandle, SourceAndConverter<?> source) {
        this(bdvHandle, new SourceAndConverter[]{source});
    }

    public ViewerTransformAdjuster(BdvHandle bdvHandle, SourceAndConverter<?>[] sources) {
        this.handle = new ViewerAdapter(bdvHandle);
        this.sources = sources;
    }

    public ViewerTransformAdjuster(ViewerAdapter handle, SourceAndConverter<?>[] sources) {
        this.handle = handle;
        this.sources = sources;
    }

    @Override
    public void run() {
        if (this.sources.length != 0) {
            AffineTransform3D transform = this.sources.length == 1 ? this.getTransform() : this.getTransformMultiSources();
            this.handle.state().setViewerTransform(transform);
        }
    }

    public AffineTransform3D getTransform() {
        ViewerState state = this.handle.state();
        int viewerWidth = (int)this.handle.getWidth();
        int viewerHeight = (int)this.handle.getHeight();
        double cX = (double)viewerWidth / 2.0;
        double cY = (double)viewerHeight / 2.0;
        int timepoint = state.getCurrentTimepoint();
        SourceAndConverter<?> source = this.sources[0];
        if (!source.getSpimSource().isPresent(timepoint)) {
            return new AffineTransform3D();
        }
        AffineTransform3D sourceTransform = new AffineTransform3D();
        source.getSpimSource().getSourceTransform(timepoint, 0, sourceTransform);
        RandomAccessibleInterval<?> sourceInterval = source.getSpimSource().getSource(timepoint, 0);
        double sX0 = sourceInterval.min(0);
        double sX1 = sourceInterval.max(0);
        double sY0 = sourceInterval.min(1);
        double sY1 = sourceInterval.max(1);
        double sZ0 = sourceInterval.min(2);
        double sZ1 = sourceInterval.max(2);
        double sX = (sX0 + sX1) / 2.0;
        double sY = (sY0 + sY1) / 2.0;
        double sZ = Math.round((sZ0 + sZ1) / 2.0);
        double[][] m = new double[3][4];
        double[] qSource = new double[4];
        double[] qViewer = new double[4];
        Affine3DHelpers.extractApproximateRotationAffine(sourceTransform, qSource, 2);
        LinAlgHelpers.quaternionInvert((double[])qSource, (double[])qViewer);
        LinAlgHelpers.quaternionToR((double[])qViewer, (double[][])m);
        double[] centerSource = new double[]{sX, sY, sZ};
        double[] centerGlobal = new double[3];
        double[] translation = new double[3];
        sourceTransform.apply(centerSource, centerGlobal);
        LinAlgHelpers.quaternionApply((double[])qViewer, (double[])centerGlobal, (double[])translation);
        LinAlgHelpers.scale((double[])translation, (double)-1.0, (double[])translation);
        LinAlgHelpers.setCol((int)3, (double[])translation, (double[][])m);
        AffineTransform3D viewerTransform = new AffineTransform3D();
        viewerTransform.set(m);
        double[] pSource = new double[]{sX1 + 0.5, sY1 + 0.5, sZ};
        double[] pGlobal = new double[3];
        double[] pScreen = new double[3];
        sourceTransform.apply(pSource, pGlobal);
        viewerTransform.apply(pGlobal, pScreen);
        double scaleX = cX / pScreen[0];
        double scaleY = cY / pScreen[1];
        double scale = Math.min(scaleX, scaleY);
        viewerTransform.scale(scale);
        viewerTransform.set(viewerTransform.get(0, 3) + cX - 0.5, 0, 3);
        viewerTransform.set(viewerTransform.get(1, 3) + cY - 0.5, 1, 3);
        return viewerTransform;
    }

    public AffineTransform3D getTransformMultiSources() {
        ViewerState state = this.handle.state();
        int timepoint = state.getCurrentTimepoint();
        List intervalList = Arrays.stream(this.sources).filter(sourceAndConverter -> sourceAndConverter.getSpimSource() != null).filter(sourceAndConverter -> sourceAndConverter.getSpimSource().isPresent(timepoint)).map(sourceAndConverter -> {
            RandomAccessibleInterval interval = sourceAndConverter.getSpimSource().getSource(timepoint, 0);
            AffineTransform3D sourceTransform = new AffineTransform3D();
            sourceAndConverter.getSpimSource().getSourceTransform(timepoint, 0, sourceTransform);
            RealPoint corner0 = new RealPoint(new float[]{interval.min(0), interval.min(1), interval.min(2)});
            RealPoint corner1 = new RealPoint(new float[]{interval.max(0), interval.max(1), interval.max(2)});
            sourceTransform.apply((RealLocalizable)corner0, (RealPositionable)corner0);
            sourceTransform.apply((RealLocalizable)corner1, (RealPositionable)corner1);
            return new FinalRealInterval(new double[]{Math.min(corner0.getDoublePosition(0), corner1.getDoublePosition(0)), Math.min(corner0.getDoublePosition(1), corner1.getDoublePosition(1)), Math.min(corner0.getDoublePosition(2), corner1.getDoublePosition(2))}, new double[]{Math.max(corner0.getDoublePosition(0), corner1.getDoublePosition(0)), Math.max(corner0.getDoublePosition(1), corner1.getDoublePosition(1)), Math.max(corner0.getDoublePosition(2), corner1.getDoublePosition(2))});
        }).collect(Collectors.toList());
        RealInterval boundingInterval = (RealInterval)intervalList.stream().reduce(Intervals::union).get();
        RealPoint center = new RealPoint(new double[]{(boundingInterval.realMin(0) + boundingInterval.realMax(0)) / 2.0, (boundingInterval.realMin(1) + boundingInterval.realMax(1)) / 2.0, (boundingInterval.realMin(2) + boundingInterval.realMax(2)) / 2.0});
        double[] centerGlobal = new double[]{center.getDoublePosition(0), center.getDoublePosition(1), center.getDoublePosition(2)};
        int viewerWidth = (int)this.handle.getWidth();
        int viewerHeight = (int)this.handle.getHeight();
        AffineTransform3D viewerTransform = new AffineTransform3D();
        this.handle.state().getViewerTransform(viewerTransform);
        viewerTransform = BdvHandleHelper.getViewerTransformWithNewCenter(this.handle, centerGlobal);
        RealPoint screenCoord = new RealPoint(new float[]{0.0f, 0.0f, 0.0f});
        List<RealPoint> boxCorners = ViewerTransformAdjuster.getBox(boundingInterval);
        double currentMinScale = Double.MAX_VALUE;
        double cX = (double)viewerWidth / 2.0;
        double cY = (double)viewerHeight / 2.0;
        for (RealPoint corner : boxCorners) {
            viewerTransform.apply((RealLocalizable)corner, (RealPositionable)screenCoord);
            double scaleX = Math.abs(cX / (screenCoord.getDoublePosition(0) - (double)viewerWidth / 2.0));
            double scaleY = Math.abs(cY / (screenCoord.getDoublePosition(1) - (double)viewerHeight / 2.0));
            currentMinScale = Math.min(currentMinScale, scaleX);
            currentMinScale = Math.min(currentMinScale, scaleY);
        }
        viewerTransform.scale(currentMinScale);
        this.handle.state().setViewerTransform(viewerTransform);
        viewerTransform = BdvHandleHelper.getViewerTransformWithNewCenter(this.handle, centerGlobal);
        return viewerTransform;
    }

    public static List<RealPoint> getBox(RealInterval ri) {
        ArrayList<RealPoint> rps = new ArrayList<RealPoint>();
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    rps.add(new RealPoint(new double[]{x == 0 ? ri.realMin(0) : ri.realMax(0), y == 0 ? ri.realMin(1) : ri.realMax(1), z == 0 ? ri.realMin(2) : ri.realMax(2)}));
                }
            }
        }
        return rps;
    }
}

