/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv.navigate;

import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.TimePointListener;
import bdv.viewer.ViewerStateChangeListener;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.imglib2.RealPoint;
import net.imglib2.realtransform.AffineTransform3D;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.bdv.navigate.ViewerTransformAdjuster;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class SourceNavigatorSliderAdder
implements Runnable {
    final BdvHandle bdvh;
    private List<RealPoint> centerLocations = new ArrayList<RealPoint>();
    private List<String> sourcesNames = new ArrayList<String>();
    final JSlider slider;
    final SpinnerNumberModel spinnerModel;
    final JSpinner spinner;
    final JPanel panel;
    final JLabel sourceName = new JLabel();
    static final ImageIcon expandIcon;
    int currentPosition;
    final ViewerStateChangeListener changeListener = viewerStateChange -> {
        switch (viewerStateChange) {
            case NUM_SOURCES_CHANGED: 
            case CURRENT_TIMEPOINT_CHANGED: 
            case VISIBILITY_CHANGED: {
                this.updatePositions();
            }
        }
    };
    final TimePointListener timePointListener = timepoint -> this.updatePositions();

    public SourceNavigatorSliderAdder(BdvHandle bdvh) {
        this.bdvh = bdvh;
        this.slider = new JSlider(0);
        this.spinnerModel = new SpinnerNumberModel(0, 0, 1, 1);
        this.spinner = new JSpinner(this.spinnerModel);
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int idx = (Integer)SourceNavigatorSliderAdder.this.spinner.getValue();
                if (SourceNavigatorSliderAdder.this.sourcesNames.size() > idx) {
                    SourceNavigatorSliderAdder.this.sourceName.setText((String)SourceNavigatorSliderAdder.this.sourcesNames.get(idx));
                }
                SourceNavigatorSliderAdder.this.slider.setValue(idx);
            }
        });
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int idx = SourceNavigatorSliderAdder.this.slider.getValue();
                if (SourceNavigatorSliderAdder.this.sourcesNames.size() > idx) {
                    SourceNavigatorSliderAdder.this.sourceName.setText((String)SourceNavigatorSliderAdder.this.sourcesNames.get(idx));
                }
                SourceNavigatorSliderAdder.this.spinner.setValue(idx);
            }
        });
        this.panel = new JPanel(new FlowLayout(0));
        this.panel.add(this.slider);
        this.panel.add(this.spinner);
        this.panel.add(this.sourceName);
        int newSize = (int)(this.panel.getPreferredSize().getHeight() * 0.6);
        Image img = expandIcon.getImage();
        Image newimg = img.getScaledInstance(newSize, newSize, 4);
        ImageIcon icon = new ImageIcon(newimg);
        JButton adjustOnSource = new JButton(icon);
        adjustOnSource.addActionListener(e -> {
            int idx = this.slider.getValue();
            if (this.sourcesNames.size() > idx) {
                List<SourceAndConverter<Object>> sortedSources = SourceAndConverterHelper.sortDefaultGeneric(bdvh.getViewerPanel().state().getVisibleSources());
                int timePoint = bdvh.getViewerPanel().state().getCurrentTimepoint();
                sortedSources = sortedSources.stream().filter(source -> source.getSpimSource().isPresent(timePoint)).collect(Collectors.toList());
                SourceAndConverter<Object> src = sortedSources.get(idx);
                new ViewerTransformAdjuster(bdvh, src).run();
            }
        });
        this.panel.add(adjustOnSource);
    }

    @Override
    public void run() {
        this.bdvh.getViewerPanel().timePointListeners().add((Object)this.timePointListener);
        this.bdvh.getViewerPanel().state().changeListeners().add((Object)this.changeListener);
        this.bdvh.getViewerPanel().add((Component)this.panel, "North");
        this.bdvh.getViewerPanel().revalidate();
        this.slider.addChangeListener(e -> {
            JSlider slider;
            int newValue;
            if (this.centerLocations.size() > 0 && this.currentPosition != (newValue = (slider = (JSlider)e.getSource()).getValue()) && newValue != -1 && newValue < this.centerLocations.size() && newValue >= 0) {
                this.currentPosition = newValue;
                AffineTransform3D at3d = new AffineTransform3D();
                this.bdvh.getViewerPanel().state().getViewerTransform(at3d);
                double[] newCenter = this.centerLocations.get(this.currentPosition).positionAsDoubleArray();
                this.bdvh.getViewerPanel().state().setViewerTransform(BdvHandleHelper.getViewerTransformWithNewCenter(this.bdvh, newCenter));
            }
        });
        this.updatePositions();
    }

    public void updatePositions() {
        List<SourceAndConverter<Object>> sortedSources = SourceAndConverterHelper.sortDefaultGeneric(this.bdvh.getViewerPanel().state().getVisibleSources());
        int timePoint = this.bdvh.getViewerPanel().state().getCurrentTimepoint();
        sortedSources = sortedSources.stream().filter(source -> source.getSpimSource().isPresent(timePoint)).collect(Collectors.toList());
        ArrayList<RealPoint> centers = new ArrayList<RealPoint>(sortedSources.size());
        ArrayList<String> srcsNames = new ArrayList<String>(sortedSources.size());
        for (SourceAndConverter<Object> source2 : sortedSources) {
            centers.add(SourceAndConverterHelper.getSourceAndConverterCenterPoint(source2, this.bdvh.getViewerPanel().state().getCurrentTimepoint()));
            srcsNames.add(source2.getSpimSource().getName());
        }
        this.centerLocations = centers;
        this.sourcesNames = srcsNames;
        if (centers.size() > 0) {
            this.slider.setMaximum(centers.size() - 1);
            this.spinnerModel.setMaximum(Integer.valueOf(centers.size() - 1));
        }
    }

    public BdvHandle getBdvh() {
        return this.bdvh;
    }

    public void removeFromBdv() {
        this.bdvh.getViewerPanel().timePointListeners().remove((Object)this.timePointListener);
        this.bdvh.getViewerPanel().state().changeListeners().remove((Object)this.changeListener);
        this.bdvh.getViewerPanel().remove(this.slider);
        this.bdvh.getViewerPanel().revalidate();
    }

    static {
        URL iconExpandURL = SourceNavigatorSliderAdder.class.getResource("/images/adjustview.png");
        expandIcon = new ImageIcon(iconExpandURL);
    }
}

