/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv.navigate;

import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.TimePointListener;
import bdv.viewer.TransformListener;
import bdv.viewer.ViewerStateChangeListener;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JSlider;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class RayCastPositionerSliderAdder
implements Runnable {
    final BdvHandle bdvh;
    private List<Double> zLocations = new ArrayList<Double>();
    final JSlider slider;
    int nPositions;
    int currentPosition;
    RealPoint lastDirection = new RealPoint(new float[0]);
    final TransformListener<AffineTransform3D> transformListener = transform -> this.updatePositions();
    final ViewerStateChangeListener changeListener = viewerStateChange -> this.updatePositions();
    final TimePointListener timePointListener = timepoint -> this.updatePositions();

    public RayCastPositionerSliderAdder(BdvHandle bdvh) {
        this.bdvh = bdvh;
        this.slider = new JSlider(1);
        this.slider.addMouseWheelListener(e -> {
            int notches = e.getWheelRotation();
            System.out.println(notches);
            if (notches < 0) {
                this.slider.setValue(this.slider.getValue() + 1);
            } else if (notches > 0) {
                this.slider.setValue(this.slider.getValue() - 1);
            }
        });
    }

    synchronized void setPositions(List<Double> zLocations) {
        int i;
        this.zLocations = new ArrayList<Double>(zLocations);
        if (this.nPositions != zLocations.size()) {
            this.nPositions = zLocations.size();
            this.slider.setMaximum(this.nPositions - 1);
        }
        for (i = 0; i < this.nPositions && this.zLocations.get(i) < 0.0; ++i) {
        }
        if (this.currentPosition != i) {
            this.currentPosition = i;
            this.slider.setValue(i);
        }
    }

    @Override
    public void run() {
        this.bdvh.getViewerPanel().transformListeners().add(this.transformListener);
        this.bdvh.getViewerPanel().timePointListeners().add((Object)this.timePointListener);
        this.bdvh.getViewerPanel().state().changeListeners().add((Object)this.changeListener);
        this.bdvh.getViewerPanel().add((Component)this.slider, "West");
        this.bdvh.getViewerPanel().revalidate();
        this.slider.addChangeListener(e -> {
            RayCastPositionerSliderAdder rayCastPositionerSliderAdder = this;
            synchronized (rayCastPositionerSliderAdder) {
                JSlider slider;
                int newValue;
                if (this.zLocations.size() > 0 && this.currentPosition != (newValue = (slider = (JSlider)e.getSource()).getValue()) && newValue != -1) {
                    this.currentPosition = newValue;
                    double shiftZ = this.zLocations.get(this.currentPosition);
                    AffineTransform3D at3d = new AffineTransform3D();
                    this.bdvh.getViewerPanel().state().getViewerTransform(at3d);
                    double[] currentCenter = BdvHandleHelper.getWindowCentreInCalibratedUnits(this.bdvh);
                    double[] newCenter = new double[]{currentCenter[0] + this.lastDirection.getDoublePosition(0) * shiftZ, currentCenter[1] + this.lastDirection.getDoublePosition(1) * shiftZ, currentCenter[2] + this.lastDirection.getDoublePosition(2) * shiftZ};
                    this.bdvh.getViewerPanel().state().setViewerTransform(BdvHandleHelper.getViewerTransformWithNewCenter(this.bdvh, newCenter));
                }
            }
        });
    }

    public synchronized void updatePositions() {
        double[] c = BdvHandleHelper.getWindowCentreInCalibratedUnits(this.bdvh);
        RealPoint origin = new RealPoint(3);
        origin.setPosition(c[0], 0);
        origin.setPosition(c[1], 1);
        origin.setPosition(c[2], 2);
        RealPoint direction = new RealPoint(new float[]{0.0f, 0.0f, 1.0f});
        AffineTransform3D affineTransform3D = new AffineTransform3D();
        this.bdvh.getViewerPanel().state().getViewerTransform(affineTransform3D);
        affineTransform3D.setTranslation(new double[]{0.0, 0.0, 0.0});
        affineTransform3D.inverse().apply((RealLocalizable)direction, (RealPositionable)direction);
        SourceAndConverterHelper.normalize3(direction);
        this.lastDirection = new RealPoint((RealLocalizable)direction);
        ArrayList<Double> zLocations = new ArrayList<Double>();
        int timepoint = this.bdvh.getViewerPanel().state().getCurrentTimepoint();
        for (SourceAndConverter<?> source : this.bdvh.getViewerPanel().state().getActiveSources()) {
            zLocations.addAll(SourceAndConverterHelper.rayIntersect(source, timepoint, origin, direction));
        }
        zLocations = zLocations.stream().map(d -> d.floatValue()).collect(Collectors.toList());
        zLocations = zLocations.stream().sorted().distinct().collect(Collectors.toList());
        this.setPositions(zLocations);
    }

    public BdvHandle getBdvh() {
        return this.bdvh;
    }

    public void removeFromBdv() {
        this.bdvh.getViewerPanel().transformListeners().remove(this.transformListener);
        this.bdvh.getViewerPanel().timePointListeners().remove((Object)this.timePointListener);
        this.bdvh.getViewerPanel().state().changeListeners().remove((Object)this.changeListener);
        this.bdvh.getViewerPanel().remove(this.slider);
        this.bdvh.getViewerPanel().revalidate();
    }
}

