/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv.config;

import bdv.TransformEventHandler2D;
import bdv.TransformEventHandler3D;
import bdv.TransformState;
import bdv.ui.settings.ModificationListener;
import bdv.ui.settings.SettingsPage;
import bdv.ui.settings.SettingsPanel;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.stream.Stream;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.commons.io.FileUtils;
import org.scijava.Context;
import org.scijava.listeners.Listeners;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.io.InputTriggerConfigHelper;
import org.scijava.ui.behaviour.io.InputTriggerDescriptionsBuilder;
import org.scijava.ui.behaviour.io.gui.VisualEditorPanel;
import org.scijava.ui.behaviour.io.yaml.YamlConfigIO;
import org.scijava.ui.behaviour.util.Behaviours;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.bdv.config.BdvPlaygroundContextualMenuSettingsPage;
import sc.fiji.bdvpg.bdv.config.BdvPrefsSettingsPage;

public class BdvSettingsGUISetter
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(BdvSettingsGUISetter.class);
    final String rootPath;
    public static final String bdvKeyConfigFileName = "bdvkeyconfig.yaml";
    public static final String editorActionsFileName = "bdvpg.editor.actions.txt";
    public static final String defaultEditorActionsFileName = "bdvpg.editor.actions.txt.default.txt";
    public static final String treeActionsFileName = "bdvpg.tree.actions.txt";
    public static final String defaultTreeActionsFileName = "bdvpg.tree.actions.txt.default.txt";
    public static final String defaultBdvPgSettingsRootPath = "plugins" + File.separator + "bdvpgsettings";
    final Context context;

    public BdvSettingsGUISetter(String path, Context context) {
        this.rootPath = path;
        this.context = context;
    }

    @Override
    public void run() {
        String pathDefaultYaml;
        File defaultKeyConfig;
        SettingsPanel settings = new SettingsPanel();
        BdvPrefsSettingsPage bdvPrefsEditor = new BdvPrefsSettingsPage("bdv prefs");
        settings.addPage(bdvPrefsEditor);
        String pathDirDefaultSettings = this.rootPath + File.separator;
        File dirDefaultSettings = new File(pathDirDefaultSettings);
        if (!dirDefaultSettings.exists()) {
            boolean bool = dirDefaultSettings.mkdir();
            if (bool) {
                logger.info("BDV Playground Directory for default settings created successfully");
            } else {
                logger.warn("Sorry couldn\u2019t create BDV Playground Directory (" + pathDirDefaultSettings + ")for settings storage");
                return;
            }
        }
        if (!(defaultKeyConfig = new File(pathDefaultYaml = dirDefaultSettings.getAbsolutePath() + File.separator + bdvKeyConfigFileName)).exists()) {
            InputTriggerConfig itc_default_2D = new InputTriggerConfig();
            TransformEventHandler2D teh2d = new TransformEventHandler2D(TransformState.from(at3d -> {}, at3d -> {}));
            Behaviours bt2d = new Behaviours((InputTriggerAdder.Factory)itc_default_2D, new String[]{"DEFAULT_2D_NAVIGATION"});
            teh2d.install(bt2d);
            InputTriggerConfig itc_default_3D = new InputTriggerConfig();
            TransformEventHandler3D teh3d = new TransformEventHandler3D(TransformState.from(at3d -> {}, at3d -> {}));
            Behaviours bt3d = new Behaviours((InputTriggerAdder.Factory)itc_default_3D, new String[]{"DEFAULT_2D_NAVIGATION"});
            teh3d.install(bt3d);
            InputTriggerConfig itc_bdvpg = new InputTriggerConfig();
            String actionContextMenu = "Sources Context Menu";
            itc_bdvpg.add("not mapped", actionContextMenu, "bdvpg");
            InputTriggerDescriptionsBuilder builder = new InputTriggerDescriptionsBuilder();
            builder.addMap(InputTriggerConfigHelper.getInputTriggerMap(itc_default_2D), "transform_bdv_2D");
            builder.addMap(InputTriggerConfigHelper.getInputTriggerMap(itc_default_3D), "transform_bdv_3D");
            builder.addMap(InputTriggerConfigHelper.getInputTriggerMap(itc_bdvpg), "bdvpg");
            builder.addMap(InputTriggerConfigHelper.getInputTriggerMap(itc_bdvpg), "transform_bdv_2D");
            builder.addMap(InputTriggerConfigHelper.getInputTriggerMap(itc_bdvpg), "transform_bdv_3D");
            try {
                YamlConfigIO.write((Iterable)builder.getDescriptions(), (String)pathDefaultYaml);
                logger.info("Default settings file successfully created: " + pathDefaultYaml);
            }
            catch (IOException e) {
                logger.warn("Couldn't write default key bindings file : " + pathDefaultYaml);
                e.printStackTrace();
                return;
            }
        }
        this.recursivelySearchAndAppend("bdvpg", settings, pathDirDefaultSettings);
        String pathDefaultContextMenuSettings = dirDefaultSettings.getAbsolutePath() + File.separator + treeActionsFileName;
        File treeActionsConfigFile = new File(pathDefaultContextMenuSettings);
        if (treeActionsConfigFile.exists()) {
            logger.debug("Actions tree config file already exists.");
        } else {
            logger.debug("Actions tree config file not present. Duplicate default config file");
            String defaultFile = dirDefaultSettings.getAbsolutePath() + File.separator + defaultTreeActionsFileName;
            if (new File(defaultFile).exists()) {
                try {
                    FileUtils.copyFile((File)new File(defaultFile), (File)new File(pathDefaultContextMenuSettings));
                }
                catch (IOException e) {
                    logger.error("Error : couldn't duplicate bdvpg default config file");
                    e.printStackTrace();
                }
            } else {
                logger.warn("Default tree actions config file for bigdataviewer-playground not present!");
            }
        }
        if (treeActionsConfigFile.exists()) {
            BdvPlaygroundContextualMenuSettingsPage spTreeActions = new BdvPlaygroundContextualMenuSettingsPage("tree actions", treeActionsConfigFile, this.context);
            settings.addPage(spTreeActions);
        }
        JDialog dialog = new JDialog((Frame)null, "BDV Playground Settings");
        dialog.getContentPane().add((Component)settings, "Center");
        dialog.pack();
        dialog.setVisible(true);
    }

    public static File getActionFile(String path, String context) {
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return new File(defaultBdvPgSettingsRootPath + File.separator + path + "bdvpg." + context + ".actions.txt");
    }

    private void recursivelySearchAndAppend(String subPath, SettingsPanel settings, String pathDir) {
        String pathDefaultEditorFile;
        File editorDefaultConfig;
        String pathEditorFile;
        File editorConfig;
        File currentDir = new File(pathDir);
        assert (currentDir.exists());
        assert (currentDir.isDirectory());
        String pathYamlFile = pathDir + File.separator + bdvKeyConfigFileName;
        File keyConfig = new File(pathYamlFile);
        if (keyConfig.exists()) {
            try {
                InputTriggerConfig yamlConf = new InputTriggerConfig((Collection)YamlConfigIO.read((String)pathYamlFile));
                VisualEditorPanel yaml_keyconfEditor = new VisualEditorPanel(yamlConf);
                yaml_keyconfEditor.setButtonPanelVisible(false);
                settings.addPage(new DefaultSettingsPage(subPath + "> settings", (JPanel)yaml_keyconfEditor));
                yaml_keyconfEditor.modelChangedListeners().add(() -> {
                    yaml_keyconfEditor.modelToConfig();
                    try {
                        YamlConfigIO.write((Iterable)new InputTriggerDescriptionsBuilder(yamlConf).getDescriptions(), (String)(pathDir + File.separator + bdvKeyConfigFileName));
                    }
                    catch (Exception e) {
                        logger.error("Could not create yaml file : settings will not be saved.");
                    }
                });
            }
            catch (IOException e) {
                logger.error("Couldn't read default key bindings file : " + pathYamlFile);
                e.printStackTrace();
            }
        }
        if (!(editorConfig = new File(pathEditorFile = pathDir + File.separator + editorActionsFileName)).exists() && (editorDefaultConfig = new File(pathDefaultEditorFile = pathDir + File.separator + editorActionsFileName + ".default.txt")).exists()) {
            try {
                FileUtils.copyFile((File)editorDefaultConfig, (File)editorConfig);
            }
            catch (IOException e) {
                logger.error("Error : couldn't duplicate bdvpg default config file");
                e.printStackTrace();
            }
        }
        if (editorConfig.exists()) {
            settings.addPage(new BdvPlaygroundContextualMenuSettingsPage(subPath + "> editor", editorConfig, this.context));
        }
        try (Stream<Path> walk = Files.walk(Paths.get(pathDir, new String[0]), new FileVisitOption[0]);){
            walk.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::toString).filter(folderPath -> !new File((String)folderPath).equals(new File(pathDir))).forEach(folderPath -> this.recursivelySearchAndAppend(subPath + ">" + new File((String)folderPath).getName(), settings, (String)folderPath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class DefaultSettingsPage
    implements SettingsPage {
        private final String treePath;
        private final JPanel panel;
        private final Listeners.List<ModificationListener> modificationListeners;

        public DefaultSettingsPage(String treePath, JPanel panel) {
            this.treePath = treePath;
            this.panel = panel;
            this.modificationListeners = new Listeners.SynchronizedList();
        }

        @Override
        public String getTreePath() {
            return this.treePath;
        }

        @Override
        public JPanel getJPanel() {
            return this.panel;
        }

        @Override
        public Listeners<ModificationListener> modificationListeners() {
            return this.modificationListeners;
        }

        @Override
        public void cancel() {
        }

        @Override
        public void apply() {
        }
    }
}

