/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv.config;

import bdv.ui.settings.ModificationListener;
import bdv.ui.settings.SettingsPage;
import bdv.util.Prefs;
import java.awt.Color;
import java.awt.GridLayout;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.scijava.listeners.Listeners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BdvPrefsSettingsPage
implements SettingsPage {
    protected static final Logger logger = LoggerFactory.getLogger(BdvPrefsSettingsPage.class);
    private final String treePath;
    private final JPanel panel;
    private final Listeners.List<ModificationListener> modificationListeners;
    private static final String SHOW_SCALE_BAR = "show-scale-bar";
    private static final String SHOW_MULTIBOX_OVERLAY = "show-multibox-overlay";
    private static final String SHOW_TEXT_OVERLAY = "show-text-overlay";
    private static final String SHOW_SCALE_BAR_IN_MOVIE = "show-scale-bar-in-movie";
    private static final String SCALE_BAR_COLOR = "scale-bar-color";
    private static final String SCALE_BAR_BG_COLOR = "scale-bar-bg-color";

    public BdvPrefsSettingsPage(String treePath) {
        this.treePath = treePath;
        this.panel = new BdvPrefsEditorPanel();
        this.modificationListeners = new Listeners.SynchronizedList();
    }

    @Override
    public String getTreePath() {
        return this.treePath;
    }

    @Override
    public JPanel getJPanel() {
        return this.panel;
    }

    @Override
    public Listeners<ModificationListener> modificationListeners() {
        return this.modificationListeners;
    }

    @Override
    public void cancel() {
        ((BdvPrefsEditorPanel)this.panel).reinit();
    }

    @Override
    public void apply() {
        try {
            File f = new File("bigdataviewer.properties");
            FileOutputStream stream = new FileOutputStream(f);
            Properties config = ((BdvPrefsEditorPanel)this.panel).getAndSetCurrentProperties();
            config.store(stream, "");
        }
        catch (IOException e) {
            logger.error("Could not create bigdataviewer.properties file");
        }
    }

    static class BdvPrefsEditorPanel
    extends JPanel {
        final JButton chooseScaleBarColor;
        final JButton chooseScaleBarBGColor;
        final JCheckBox showScaleBar;
        final JCheckBox showMultiboxOverlay;
        final JCheckBox showTextOverlay;
        final JCheckBox showScaleBarInMovie;
        Color scaleBarColor;
        Color scaleBarBGColor;

        public BdvPrefsEditorPanel() {
            this.setLayout(new GridLayout(0, 2));
            this.add(new JLabel(BdvPrefsSettingsPage.SHOW_SCALE_BAR));
            this.showScaleBar = new JCheckBox("", Prefs.showScaleBar());
            this.add(this.showScaleBar);
            this.add(new JLabel(BdvPrefsSettingsPage.SHOW_MULTIBOX_OVERLAY));
            this.showMultiboxOverlay = new JCheckBox("", Prefs.showMultibox());
            this.add(this.showMultiboxOverlay);
            this.add(new JLabel(BdvPrefsSettingsPage.SHOW_TEXT_OVERLAY));
            this.showTextOverlay = new JCheckBox("", Prefs.showTextOverlay());
            this.add(this.showTextOverlay);
            this.add(new JLabel(BdvPrefsSettingsPage.SHOW_SCALE_BAR_IN_MOVIE));
            this.showScaleBarInMovie = new JCheckBox("", Prefs.showScaleBarInMovie());
            this.add(this.showScaleBarInMovie);
            this.add(new JLabel(BdvPrefsSettingsPage.SCALE_BAR_COLOR));
            this.chooseScaleBarColor = new JButton("Set Scale Bar Color");
            this.chooseScaleBarColor.setForeground(new Color(Prefs.scaleBarColor()));
            this.chooseScaleBarColor.setBackground(new Color(Prefs.scaleBarColor()));
            this.chooseScaleBarColor.addActionListener(e -> {
                this.scaleBarColor = JColorChooser.showDialog(this, "Choose Scale Bar Color", new Color(Prefs.scaleBarColor()));
                if (this.scaleBarColor == null) {
                    this.scaleBarColor = new Color(Prefs.scaleBarColor());
                }
                this.chooseScaleBarColor.setForeground(this.scaleBarColor);
                this.chooseScaleBarColor.setBackground(this.scaleBarColor);
            });
            this.add(this.chooseScaleBarColor);
            this.add(new JLabel(BdvPrefsSettingsPage.SCALE_BAR_BG_COLOR));
            this.chooseScaleBarBGColor = new JButton("Set Scale Bar Background Color");
            this.chooseScaleBarBGColor.setForeground(new Color(Prefs.scaleBarBgColor()));
            this.chooseScaleBarBGColor.setBackground(new Color(Prefs.scaleBarBgColor()));
            this.chooseScaleBarBGColor.addActionListener(e -> {
                this.scaleBarBGColor = JColorChooser.showDialog(this, "Choose Scale Bar Background Color", new Color(Prefs.scaleBarBgColor()));
                if (this.scaleBarBGColor == null) {
                    this.scaleBarBGColor = new Color(Prefs.scaleBarBgColor());
                }
                this.chooseScaleBarBGColor.setForeground(this.scaleBarBGColor);
                this.chooseScaleBarBGColor.setBackground(this.scaleBarBGColor);
            });
            this.add(this.chooseScaleBarBGColor);
            this.reinit();
        }

        void reinit() {
            this.showScaleBar.setSelected(Prefs.showScaleBar());
            this.showMultiboxOverlay.setSelected(Prefs.showMultibox());
            this.showTextOverlay.setSelected(Prefs.showTextOverlay());
            this.showScaleBarInMovie.setSelected(Prefs.showScaleBarInMovie());
            this.scaleBarColor = new Color(Prefs.scaleBarColor());
            this.chooseScaleBarColor.setForeground(this.scaleBarColor);
            this.chooseScaleBarColor.setBackground(this.scaleBarColor);
            this.scaleBarBGColor = new Color(Prefs.scaleBarBgColor());
            this.chooseScaleBarBGColor.setForeground(this.scaleBarBGColor);
            this.chooseScaleBarBGColor.setBackground(this.scaleBarBGColor);
        }

        Properties getAndSetCurrentProperties() {
            Prefs.showScaleBar(this.showScaleBar.isSelected());
            Prefs.showMultibox(this.showMultiboxOverlay.isSelected());
            Prefs.showTextOverlay(this.showTextOverlay.isSelected());
            Prefs.showScaleBarInMovie(this.showScaleBarInMovie.isSelected());
            Prefs.scaleBarColor(this.scaleBarColor.getRGB());
            Prefs.scaleBarBgColor(this.scaleBarBGColor.getRGB());
            Properties props = new Properties();
            props.setProperty(BdvPrefsSettingsPage.SHOW_SCALE_BAR, Boolean.toString(Prefs.showScaleBar()));
            props.setProperty(BdvPrefsSettingsPage.SHOW_MULTIBOX_OVERLAY, Boolean.toString(Prefs.showMultibox()));
            props.setProperty(BdvPrefsSettingsPage.SHOW_TEXT_OVERLAY, Boolean.toString(Prefs.showTextOverlay()));
            props.setProperty(BdvPrefsSettingsPage.SHOW_SCALE_BAR_IN_MOVIE, Boolean.toString(Prefs.showScaleBarInMovie()));
            props.setProperty(BdvPrefsSettingsPage.SCALE_BAR_COLOR, Integer.toString(Prefs.scaleBarColor()));
            props.setProperty(BdvPrefsSettingsPage.SCALE_BAR_BG_COLOR, Integer.toString(Prefs.scaleBarBgColor()));
            return props;
        }
    }
}

