/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv.config;

import bdv.ui.settings.ModificationListener;
import bdv.ui.settings.SettingsPage;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import javax.swing.DropMode;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.scijava.Context;
import org.scijava.listeners.Listeners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;

public class BdvPlaygroundContextualMenuSettingsPage
implements SettingsPage {
    protected static final Logger logger = LoggerFactory.getLogger(BdvPlaygroundContextualMenuSettingsPage.class);
    private final String treePath;
    private final JPanel panel;
    private final Listeners.List<ModificationListener> modificationListeners;
    final File jsonActionFile;
    final Context context;

    public BdvPlaygroundContextualMenuSettingsPage(String treePath, File jsonEditorActions, Context context) {
        this.context = context;
        this.treePath = treePath;
        this.jsonActionFile = jsonEditorActions;
        String[] iniActions = new String[]{};
        if (this.jsonActionFile.exists()) {
            try {
                Gson gson = new Gson();
                iniActions = (String[])gson.fromJson((Reader)new FileReader(this.jsonActionFile.getAbsoluteFile()), String[].class);
                if (iniActions == null) {
                    iniActions = new String[]{};
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            logger.warn("Bdv Playground actions settings File " + this.jsonActionFile.getAbsolutePath() + " does not exist.");
        }
        this.panel = new BdvPgContextMenuEditor(iniActions, context);
        this.modificationListeners = new Listeners.SynchronizedList();
    }

    @Override
    public String getTreePath() {
        return this.treePath;
    }

    @Override
    public JPanel getJPanel() {
        return this.panel;
    }

    @Override
    public Listeners<ModificationListener> modificationListeners() {
        return this.modificationListeners;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void apply() {
        String[] actions = ((BdvPgContextMenuEditor)this.panel).getActions();
        ArrayList<String> filteredActions = new ArrayList<String>();
        for (int i = 0; i < actions.length; ++i) {
            actions[i] = actions[i].trim();
            if (actions[i] == null) continue;
            if (actions[i].equals("")) {
                filteredActions.add("PopupLine");
                continue;
            }
            filteredActions.add(actions[i]);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String actionsString = gson.toJson((Object)filteredActions.toArray(new String[0]));
        try {
            PrintWriter out = new PrintWriter(this.jsonActionFile);
            out.println(actionsString);
            out.close();
        }
        catch (FileNotFoundException e) {
            logger.error("Could not print actions settings file " + this.jsonActionFile.getAbsolutePath());
            e.printStackTrace();
        }
    }

    static class BdvPgContextMenuEditor
    extends JPanel {
        private final JTextArea contextMenuActions;

        public BdvPgContextMenuEditor(String[] initialState, Context context) {
            this.setLayout(new GridLayout(0, 2));
            String[] allActionKeys = new ArrayList<String>(((SourceAndConverterService)context.getService(SourceAndConverterService.class)).getActionsKeys()).toArray(new String[0]);
            JList<String> allActions = new JList<String>(allActionKeys);
            this.contextMenuActions = new JTextArea();
            this.contextMenuActions.setFont(this.contextMenuActions.getFont().deriveFont(10.0f));
            allActions.setDragEnabled(true);
            this.contextMenuActions.setDragEnabled(true);
            this.contextMenuActions.setDropMode(DropMode.INSERT);
            StringBuilder sb = new StringBuilder();
            for (String action : initialState) {
                sb.append(action).append("\n");
            }
            this.contextMenuActions.setText(sb.toString());
            this.add((Component)new JScrollPane(this.contextMenuActions), "West");
            this.add((Component)new JScrollPane(allActions), "East");
        }

        String[] getActions() {
            String actions = this.contextMenuActions.getText();
            actions = actions + "\n";
            return actions.split("\n");
        }
    }
}

