/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv;

import bdv.viewer.SourceAndConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.imglib2.realtransform.AffineTransform3D;
import sc.fiji.bdvpg.bdv.ManualRegistrationStarter;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterAndTimeRange;

public class ManualRegistrationStopper
implements Runnable {
    final ManualRegistrationStarter starter;
    final BiFunction<AffineTransform3D, SourceAndConverterAndTimeRange<?>, SourceAndConverter<?>> registrationPolicy;
    SourceAndConverter<?>[] transformedSources;
    int minTimepoint;
    int maxTimepoint;

    public ManualRegistrationStopper(ManualRegistrationStarter starter, BiFunction<AffineTransform3D, SourceAndConverterAndTimeRange<?>, SourceAndConverter<?>> registrationPolicy) {
        this.starter = starter;
        this.registrationPolicy = registrationPolicy;
        this.minTimepoint = starter.bdvHandle.getViewerPanel().state().getCurrentTimepoint();
        this.maxTimepoint = starter.bdvHandle.getViewerPanel().state().getCurrentTimepoint() + 1;
    }

    public void setTimeRange(int min, int max) {
        this.minTimepoint = min;
        this.maxTimepoint = max;
    }

    @Override
    public void run() {
        AffineTransform3D transform3D = this.starter.getCurrentTransform().copy();
        this.starter.getBdvHandle().getViewerPanel().transformListeners().remove(this.starter.getListener());
        List<SourceAndConverter<?>> tempSacs = this.starter.getTransformedSourceAndConverterDisplayed();
        SourceAndConverterServices.getBdvDisplayService().remove(this.starter.bdvHandle, tempSacs.toArray(new SourceAndConverter[0]));
        for (SourceAndConverter<?> sac : tempSacs) {
            SourceAndConverterServices.getSourceAndConverterService().remove(sac);
        }
        int nSources = this.starter.getOriginalSourceAndConverter().length;
        this.transformedSources = new SourceAndConverter[nSources];
        ArrayList transformedSacsToDisplay = new ArrayList();
        for (int i = 0; i < nSources; ++i) {
            SourceAndConverter<?> sac = this.starter.getOriginalSourceAndConverter()[i];
            this.transformedSources[i] = this.registrationPolicy.apply(transform3D, new SourceAndConverterAndTimeRange(sac, this.minTimepoint, this.maxTimepoint));
            if (!this.starter.getOriginallyDisplayedSourceAndConverter().contains(sac)) continue;
            transformedSacsToDisplay.add(this.transformedSources[i]);
        }
        SourceAndConverterServices.getBdvDisplayService().show(this.starter.getBdvHandle(), transformedSacsToDisplay.toArray(new SourceAndConverter[0]));
    }

    public SourceAndConverter<?>[] getTransformedSources() {
        return this.transformedSources;
    }
}

