/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv;

import bdv.tools.transformation.TransformedSource;
import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.TransformListener;
import java.util.ArrayList;
import java.util.List;
import net.imglib2.realtransform.AffineTransform3D;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceAffineTransformer;

public class ManualRegistrationStarter
implements Runnable {
    final SourceAndConverter<?>[] sacs;
    final List<SourceAndConverter<?>> originallyDisplayedSacs = new ArrayList();
    final List<SourceAndConverter<?>> displayedSacsWrapped = new ArrayList();
    final BdvHandle bdvHandle;
    AffineTransform3D currentRegistration;
    TransformListener<AffineTransform3D> manualRegistrationListener;

    public ManualRegistrationStarter(BdvHandle bdvHandle, SourceAndConverter<?> ... sacs) {
        this.sacs = sacs;
        this.bdvHandle = bdvHandle;
    }

    @Override
    public void run() {
        for (SourceAndConverter<?> sourceAndConverter : this.sacs) {
            if (!SourceAndConverterServices.getBdvDisplayService().getDisplaysOf(sourceAndConverter).contains(this.bdvHandle) || !SourceAndConverterServices.getBdvDisplayService().isVisible(sourceAndConverter, this.bdvHandle)) continue;
            this.displayedSacsWrapped.add(new SourceAffineTransformer(sourceAndConverter, new AffineTransform3D()).get());
            this.originallyDisplayedSacs.add(sourceAndConverter);
        }
        SourceAndConverterServices.getBdvDisplayService().remove(this.bdvHandle, this.originallyDisplayedSacs.toArray(new SourceAndConverter[0]));
        SourceAndConverterServices.getBdvDisplayService().show(this.bdvHandle, this.displayedSacsWrapped.toArray(new SourceAndConverter[0]));
        AffineTransform3D originalViewTransform = new AffineTransform3D();
        this.bdvHandle.getViewerPanel().state().getViewerTransform(originalViewTransform);
        this.manualRegistrationListener = newView -> {
            this.currentRegistration = newView.copy();
            this.currentRegistration = this.currentRegistration.inverse();
            this.currentRegistration.concatenate(originalViewTransform);
            this.displayedSacsWrapped.forEach(sac -> ((TransformedSource)sac.getSpimSource()).setFixedTransform(this.currentRegistration));
        };
        this.bdvHandle.getViewerPanel().transformListeners().add(this.manualRegistrationListener);
    }

    public BdvHandle getBdvHandle() {
        return this.bdvHandle;
    }

    public TransformListener<AffineTransform3D> getListener() {
        return this.manualRegistrationListener;
    }

    public List<SourceAndConverter<?>> getTransformedSourceAndConverterDisplayed() {
        return this.displayedSacsWrapped;
    }

    public SourceAndConverter<?>[] getOriginalSourceAndConverter() {
        return this.sacs;
    }

    public List<SourceAndConverter<?>> getOriginallyDisplayedSourceAndConverter() {
        return this.originallyDisplayedSacs;
    }

    public AffineTransform3D getCurrentTransform() {
        return ManualRegistrationStarter.ensureOrthoNormalTransform(this.currentRegistration);
    }

    public static AffineTransform3D ensureOrthoNormalTransform(AffineTransform3D at3D) {
        AffineTransform3D correctedAffineTransform = new AffineTransform3D();
        correctedAffineTransform.set(at3D);
        double v1x = at3D.get(0, 0);
        double v1y = at3D.get(0, 1);
        double v1z = at3D.get(0, 2);
        double v2x = at3D.get(1, 0);
        double v2y = at3D.get(1, 1);
        double v2z = at3D.get(1, 2);
        double normv1 = Math.sqrt(v1x * v1x + v1y * v1y + v1z * v1z);
        double normv2 = Math.sqrt(v2x * v2x + v2y * v2y + v2z * v2z);
        if (Math.abs(normv1 - normv2) / normv1 > 1.0E-10) {
            v2x = v2x / normv2 * normv1;
            v2y = v2y / normv2 * normv1;
            v2z = v2z / normv2 * normv1;
            correctedAffineTransform.set(v2x, 1, 0);
            correctedAffineTransform.set(v2y, 1, 1);
            correctedAffineTransform.set(v2z, 1, 2);
        }
        if (Math.abs(v1x * v2x + v1y * v2y + v1z * v2z) / (normv1 * normv2) > 1.0E-10) {
            double u1x = v1x / normv1;
            double u1y = v1y / normv1;
            double u1z = v1z / normv1;
            double dotProductNormalized = u1x * v2x + u1y * v2y + u1z * v2z;
            normv2 = Math.sqrt((v2x -= dotProductNormalized * u1x) * v2x + (v2y -= dotProductNormalized * u1y) * v2y + (v2z -= dotProductNormalized * u1z) * v2z);
            v2x = v2x / normv2 * normv1;
            v2y = v2y / normv2 * normv1;
            v2z = v2z / normv2 * normv1;
            correctedAffineTransform.set(v2x, 1, 0);
            correctedAffineTransform.set(v2y, 1, 1);
            correctedAffineTransform.set(v2z, 1, 2);
        }
        double xr = (v1y * v2z - v1z * v2y) / normv1;
        double yr = (v1z * v2x - v1x * v2z) / normv1;
        double zr = (v1x * v2y - v1y * v2x) / normv1;
        correctedAffineTransform.set(xr, 2, 0);
        correctedAffineTransform.set(yr, 2, 1);
        correctedAffineTransform.set(zr, 2, 2);
        return correctedAffineTransform;
    }
}

