/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv;

import bdv.tools.brightness.ConverterSetup;
import bdv.util.Bdv;
import bdv.util.BdvFunctions;
import bdv.util.BdvHandle;
import bdv.util.BdvHandleFrame;
import bdv.util.BdvHandlePanel;
import bdv.util.BdvOptions;
import bdv.util.BdvOverlay;
import bdv.viewer.Source;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.imglib2.FinalInterval;
import net.imglib2.FinalRealInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.util.Intervals;
import net.imglib2.util.LinAlgHelpers;
import org.scijava.cache.CacheService;
import org.scijava.object.ObjectService;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.io.InputTriggerConfigHelper;
import org.scijava.ui.behaviour.io.yaml.YamlConfigIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterBdvDisplayService;
import sc.fiji.bdvpg.viewers.ViewerAdapter;

public class BdvHandleHelper {
    protected static final Logger logger = LoggerFactory.getLogger(BdvHandleHelper.class);

    public static AffineTransform3D getViewerTransformWithNewCenter(BdvHandle bdvHandle, double[] xyz) {
        return BdvHandleHelper.getViewerTransformWithNewCenter(new ViewerAdapter(bdvHandle), xyz);
    }

    public static AffineTransform3D getViewerTransformWithNewCenter(ViewerAdapter handle, double[] xyz) {
        AffineTransform3D currentViewerTransform = new AffineTransform3D();
        handle.state().getViewerTransform(currentViewerTransform);
        AffineTransform3D adaptedViewerTransform = currentViewerTransform.copy();
        double[] targetPositionInViewerInPixels = new double[3];
        currentViewerTransform.apply(xyz, targetPositionInViewerInPixels);
        int d = 0;
        while (d < 3) {
            int n = d++;
            targetPositionInViewerInPixels[n] = targetPositionInViewerInPixels[n] * -1.0;
        }
        adaptedViewerTransform.translate(targetPositionInViewerInPixels);
        double[] windowCentreInViewerInPixels = BdvHandleHelper.getWindowCentreInPixelUnits(handle);
        adaptedViewerTransform.translate(windowCentreInViewerInPixels);
        return adaptedViewerTransform;
    }

    public static double[] getWindowCentreInPixelUnits(ViewerAdapter handle) {
        double[] windowCentreInPixelUnits = new double[3];
        windowCentreInPixelUnits[0] = handle.getWidth() / 2.0;
        windowCentreInPixelUnits[1] = handle.getHeight() / 2.0;
        return windowCentreInPixelUnits;
    }

    public static double[] getWindowCentreInPixelUnits(BdvHandle bdvHandle) {
        return BdvHandleHelper.getWindowCentreInPixelUnits(new ViewerAdapter(bdvHandle));
    }

    public static double[] getWindowCentreInCalibratedUnits(BdvHandle bdvHandle) {
        double[] centreInPixelUnits = BdvHandleHelper.getWindowCentreInPixelUnits(bdvHandle);
        AffineTransform3D affineTransform3D = new AffineTransform3D();
        bdvHandle.getViewerPanel().state().getViewerTransform(affineTransform3D);
        double[] centreInCalibratedUnits = new double[3];
        affineTransform3D.inverse().apply(centreInPixelUnits, centreInCalibratedUnits);
        return centreInCalibratedUnits;
    }

    public static double getViewerVoxelSpacing(BdvHandle bdv) {
        int windowWidth = bdv.getViewerPanel().getDisplay().getWidth();
        int windowHeight = bdv.getViewerPanel().getDisplay().getHeight();
        AffineTransform3D viewerTransform = new AffineTransform3D();
        bdv.getViewerPanel().state().getViewerTransform(viewerTransform);
        double[] physicalA = new double[3];
        double[] physicalB = new double[3];
        viewerTransform.applyInverse(physicalA, new double[]{0.0, 0.0, 0.0});
        viewerTransform.applyInverse(physicalB, new double[]{0.0, windowWidth, 0.0});
        double viewerPhysicalWidth = LinAlgHelpers.distance((double[])physicalA, (double[])physicalB);
        viewerTransform.applyInverse(physicalA, new double[]{0.0, 0.0, 0.0});
        viewerTransform.applyInverse(physicalB, new double[]{windowHeight, 0.0, 0.0});
        double viewerPhysicalHeight = LinAlgHelpers.distance((double[])physicalA, (double[])physicalB);
        double viewerPhysicalVoxelSpacingX = viewerPhysicalWidth / (double)windowWidth;
        double viewerPhysicalVoxelSpacingY = viewerPhysicalHeight / (double)windowHeight;
        logger.debug("windowWidth = " + windowWidth);
        logger.debug("windowHeight = " + windowHeight);
        logger.debug("viewerPhysicalWidth = " + viewerPhysicalWidth);
        logger.debug("viewerPhysicalHeight = " + viewerPhysicalHeight);
        logger.debug("viewerPhysicalVoxelSpacingX = " + viewerPhysicalVoxelSpacingX);
        logger.debug("viewerPhysicalVoxelSpacingY = " + viewerPhysicalVoxelSpacingY);
        return viewerPhysicalVoxelSpacingX;
    }

    public static boolean isSourceIntersectingCurrentView(BdvHandle bdv, Source<?> source, boolean is2D) {
        if (source.getSource(0, 0) == null) {
            return false;
        }
        Interval interval = BdvHandleHelper.getSourceGlobalBoundingInterval(source, bdv.getViewerPanel().state().getCurrentTimepoint());
        Interval viewerInterval = Intervals.smallestContainingInterval((RealInterval)BdvHandleHelper.getViewerGlobalBoundingInterval(bdv));
        boolean intersects = is2D ? !Intervals.isEmpty((Interval)BdvHandleHelper.intersect2D(interval, viewerInterval)) : !Intervals.isEmpty((Interval)Intervals.intersect((Interval)interval, (Interval)viewerInterval));
        return intersects;
    }

    public static FinalInterval intersect2D(Interval intervalA, Interval intervalB) {
        assert (intervalA.numDimensions() == intervalB.numDimensions());
        long[] min = new long[2];
        long[] max = new long[2];
        for (int d = 0; d < 2; ++d) {
            min[d] = Math.max(intervalA.min(d), intervalB.min(d));
            max[d] = Math.min(intervalA.max(d), intervalB.max(d));
        }
        return new FinalInterval(min, max);
    }

    public static FinalRealInterval getViewerGlobalBoundingInterval(BdvHandle bdvHandle) {
        AffineTransform3D viewerTransform = new AffineTransform3D();
        bdvHandle.getViewerPanel().state().getViewerTransform(viewerTransform);
        viewerTransform = viewerTransform.inverse();
        long[] min = new long[3];
        long[] max = new long[3];
        max[0] = bdvHandle.getViewerPanel().getWidth();
        max[1] = bdvHandle.getViewerPanel().getHeight();
        return viewerTransform.estimateBounds((RealInterval)new FinalInterval(min, max));
    }

    public static Interval getSourceGlobalBoundingInterval(Source<?> source, int timepoint) {
        AffineTransform3D sourceTransform = BdvHandleHelper.getSourceTransform(source, timepoint);
        RandomAccessibleInterval<?> rai = source.getSource(timepoint, 0);
        return Intervals.smallestContainingInterval((RealInterval)sourceTransform.estimateBounds(rai));
    }

    public static AffineTransform3D getSourceTransform(Source<?> source, int timepoint) {
        return BdvHandleHelper.getSourceTransform(source, timepoint, 0);
    }

    public static int getLevel(Source<?> source, double ... voxelSpacings) {
        int numMipmapLevels = source.getNumMipmapLevels();
        int numDimensions = voxelSpacings.length;
        for (int level = numMipmapLevels - 1; level >= 0; --level) {
            double[] calibration = BdvHandleHelper.getCalibration(source, level);
            boolean allSpacingsSmallerThanRequested = true;
            for (int d = 0; d < numDimensions; ++d) {
                if (!(calibration[d] > voxelSpacings[d])) continue;
                allSpacingsSmallerThanRequested = false;
                break;
            }
            if (!allSpacingsSmallerThanRequested) continue;
            return level;
        }
        return 0;
    }

    public static AffineTransform3D getSourceTransform(Source<?> source, int t, int level) {
        AffineTransform3D sourceTransform = new AffineTransform3D();
        source.getSourceTransform(t, level, sourceTransform);
        return sourceTransform;
    }

    public static double[] getCalibration(Source<?> source, int level) {
        AffineTransform3D sourceTransform = new AffineTransform3D();
        source.getSourceTransform(0, level, sourceTransform);
        return BdvHandleHelper.getScale(sourceTransform);
    }

    public static double[] getScale(AffineTransform3D sourceTransform) {
        double[] calibration = new double[3];
        for (int d = 0; d < 3; ++d) {
            double[] vector = new double[3];
            for (int i = 0; i < 3; ++i) {
                vector[i] = sourceTransform.get(d, i);
            }
            calibration[d] = LinAlgHelpers.length((double[])vector);
        }
        return calibration;
    }

    public static double[] getDisplayRange(ConverterSetup converterSetup) {
        double displayRangeMin = converterSetup.getDisplayRangeMin();
        double displayRangeMax = converterSetup.getDisplayRangeMax();
        return new double[]{displayRangeMin, displayRangeMax};
    }

    public static JFrame getJFrame(BdvHandle bdvh) {
        if (!(bdvh instanceof BdvHandleFrame)) {
            throw new RuntimeException("The BdvHandle is a Panel, not a Frame");
        }
        return (JFrame)SwingUtilities.getWindowAncestor(bdvh.getViewerPanel());
    }

    public static void setBdvHandleCloseOperation(final BdvHandle bdvh, final CacheService cs, final SourceAndConverterBdvDisplayService bdvsds, boolean putWindowOnTop, final Runnable runnable) {
        if (bdvh instanceof BdvHandlePanel) {
            throw new RuntimeException("The BdvHandle is a Panel, not a Frame");
        }
        final JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(bdvh.getViewerPanel());
        WindowAdapter wa = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (runnable != null) {
                    runnable.run();
                }
                super.windowClosing(e);
                bdvsds.closeBdv(bdvh);
                topFrame.removeWindowListener(this);
                e.getWindow().dispose();
                bdvh.close();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                super.windowActivated(e);
                cs.put((Object)"LAST_ACTIVE_BDVH", new WeakReference<BdvHandle>(bdvh));
            }
        };
        topFrame.addWindowListener(wa);
        if (putWindowOnTop) {
            cs.put((Object)"LAST_ACTIVE_BDVH", new WeakReference<BdvHandle>(bdvh));
        }
    }

    public static void activateWindow(BdvHandle bdvh) {
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(bdvh.getViewerPanel());
        if (topFrame != null) {
            topFrame.toFront();
            topFrame.requestFocus();
        } else {
            bdvh.getViewerPanel().requestFocus();
        }
    }

    public static void closeWindow(BdvHandle bdvh) {
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(bdvh.getViewerPanel());
        if (topFrame != null) {
            topFrame.dispatchEvent(new WindowEvent(topFrame, 201));
        } else {
            System.err.println("Can't close the bdv handle because it is of class " + bdvh.getClass().getName());
        }
    }

    public static void setWindowTitle(BdvHandle bdvh, String title) {
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(bdvh.getViewerPanel());
        if (topFrame != null) {
            topFrame.setTitle(title);
        } else {
            System.err.println("Can't set the bdv handle window title because it is of class " + bdvh.getClass().getName());
        }
    }

    public static String getWindowTitle(BdvHandle bdvh) {
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(bdvh.getViewerPanel());
        if (topFrame == null) {
            System.err.println("Can't set the window title since the bdv handle because it is of class " + bdvh.getClass().getName());
            return bdvh.toString();
        }
        return topFrame.getTitle();
    }

    public static String getUniqueWindowTitle(ObjectService os, String iniTitle) {
        boolean duplicateExist;
        List bdvs = os.getObjects(BdvHandle.class);
        String uniqueTitle = iniTitle;
        boolean bl = duplicateExist = bdvs.stream().filter(bdv -> bdv.toString().equals(iniTitle) || BdvHandleHelper.getWindowTitle(bdv).equals(iniTitle)).count() > 1L;
        while (duplicateExist) {
            if (uniqueTitle.matches(".+(_)\\d+")) {
                int idx = Integer.parseInt(uniqueTitle.substring(uniqueTitle.lastIndexOf("_") + 1));
                uniqueTitle = uniqueTitle.substring(0, uniqueTitle.lastIndexOf("_") + 1);
                uniqueTitle = uniqueTitle + String.format("%02d", idx + 1);
            } else {
                uniqueTitle = uniqueTitle + "_00";
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String uTTest = uniqueTitle;
            duplicateExist = bdvs.stream().anyMatch(bdv -> bdv.toString().equals(uTTest) || BdvHandleHelper.getWindowTitle(bdv).equals(uTTest));
        }
        return uniqueTitle;
    }

    public static void printBindings(BdvHandle bdv, Consumer<String> stringEater) {
        stringEater.accept("--------------------- Behaviours");
        bdv.getTriggerbindings().getConcatenatedBehaviourMap().getAllBindings().forEach((label, behaviour) -> {
            stringEater.accept("Label: " + label);
            stringEater.accept("\t" + behaviour.getClass().getSimpleName());
        });
        stringEater.accept("--------------------- Triggers");
        bdv.getTriggerbindings().getConcatenatedInputTriggerMap().getAllBindings().forEach((trigger, actions) -> {
            stringEater.accept("Trigger: " + trigger.toString());
            for (String action : actions) {
                stringEater.accept("\t" + action);
            }
        });
        stringEater.accept("--------------------- Key Action");
        for (Object o : bdv.getKeybindings().getConcatenatedActionMap().allKeys()) {
            stringEater.accept("\t" + o);
        }
        stringEater.accept("--------------------- Key Triggers");
        if (bdv.getKeybindings().getConcatenatedInputMap() != null) {
            if (bdv.getKeybindings().getConcatenatedInputMap().allKeys() != null) {
                for (KeyStroke ks : bdv.getKeybindings().getConcatenatedInputMap().allKeys()) {
                    stringEater.accept("\t" + ks + ":" + bdv.getKeybindings().getConcatenatedInputMap().get(ks));
                }
                stringEater.accept("Null keys in Keybindings ConcatenatedInputMap!");
            }
        } else {
            stringEater.accept("Null Keybindings InputMap!");
        }
    }

    static void install(BdvHandle bdv, String pathToBindings) {
        String yamlDataLocation = pathToBindings + File.separator + "bdvkeyconfig.yaml";
        InputTriggerConfig yamlConf = null;
        try {
            yamlConf = new InputTriggerConfig((Collection)YamlConfigIO.read((String)yamlDataLocation));
        }
        catch (Exception e) {
            logger.warn("Could not create " + yamlDataLocation + " file. Using defaults instead.");
        }
        if (yamlConf != null) {
            bdv.getTriggerbindings().addInputTriggerMap(pathToBindings, InputTriggerConfigHelper.getInputTriggerMap(yamlConf), new String[]{"transform"});
        }
    }

    public static BdvOverlay addCenterCross(final BdvHandle bdvh) {
        BdvOverlay overlay = new BdvOverlay(){

            protected void draw(Graphics2D g) {
                int colorCode = this.info.getColor().get();
                int w = bdvh.getViewerPanel().getWidth();
                int h = bdvh.getViewerPanel().getHeight();
                g.setColor(new Color(ARGBType.red((int)colorCode), ARGBType.green((int)colorCode), ARGBType.blue((int)colorCode), ARGBType.alpha((int)colorCode)));
                g.drawLine(w / 2, h / 2 - h / 4, w / 2, h / 2 + h / 4);
                g.drawLine(w / 2 - w / 4, h / 2, w / 2 + w / 4, h / 2);
            }
        };
        int nTimepoints = bdvh.getViewerPanel().state().getNumTimepoints();
        int iTimePoint = bdvh.getViewerPanel().state().getCurrentTimepoint();
        BdvFunctions.showOverlay((BdvOverlay)overlay, (String)"cross_overlay", (BdvOptions)BdvOptions.options().addTo((Bdv)bdvh));
        bdvh.getViewerPanel().state().setNumTimepoints(nTimepoints);
        bdvh.getViewerPanel().state().setCurrentTimepoint(iTimePoint);
        return overlay;
    }

    public static void addCard(BdvHandle bdvh, String title, JComponent component, boolean expanded) {
        SwingUtilities.invokeLater(() -> bdvh.getCardPanel().addCard(title, component, expanded));
    }

    public static void removeCard(BdvHandle bdvh, Object key) {
        SwingUtilities.invokeLater(() -> bdvh.getCardPanel().removeCard(key));
    }
}

